/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.player.Player;

public class PlaceholderReplacer {
    public static String replace(Player player, String message, HuskChat implementingPlugin) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%name%", PlaceholderReplacer.escape(implementingPlugin.getDataGetter().getPlayerName(player)));
        placeholders.put("%fullname%", PlaceholderReplacer.escape(implementingPlugin.getDataGetter().getPlayerFullName(player)));
        placeholders.put("%prefix%", implementingPlugin.getDataGetter().getPlayerPrefix(player).isPresent() ? implementingPlugin.getDataGetter().getPlayerPrefix(player).get() : "");
        placeholders.put("%suffix%", implementingPlugin.getDataGetter().getPlayerSuffix(player).isPresent() ? implementingPlugin.getDataGetter().getPlayerSuffix(player).get() : "");
        placeholders.put("%ping%", Integer.toString(player.getPing()));
        placeholders.put("%uuid%", player.getUuid().toString());
        placeholders.put("%servername%", Settings.serverNameReplacement.getOrDefault(player.getServerName(), player.getServerName()));
        placeholders.put("%serverplayercount%", Integer.toString(player.getPlayersOnServer()));
        Date date = new Date();
        placeholders.put("%timestamp%", new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(date));
        placeholders.put("%time%", new SimpleDateFormat("HH:mm:ss").format(date));
        placeholders.put("%short_time%", new SimpleDateFormat("HH:mm").format(date));
        placeholders.put("%date%", new SimpleDateFormat("yyyy/MM/dd").format(date));
        placeholders.put("%british_date%", new SimpleDateFormat("dd/MM/yyyy").format(date));
        placeholders.put("%day%", new SimpleDateFormat("dd").format(date));
        placeholders.put("%month%", new SimpleDateFormat("MM").format(date));
        placeholders.put("%year%", new SimpleDateFormat("yyyy").format(date));
        for (String placeholder : placeholders.keySet()) {
            String replacement = (String)placeholders.get(placeholder);
            message = message.replace(placeholder, replacement);
        }
        return message;
    }

    public static String escape(String string) {
        return string.replace("__", "_\\_");
    }
}

