/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.libraries.profanitycheckerapi;

import java.util.Arrays;
import java.util.List;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.libraries.profanitycheckerapi.Normalizer;
import net.william278.huskchat.libraries.profanitycheckerapi.ProfanityChecker;

public class ProfanityCheckerBuilder {
    @Nullable
    private String libraryPath;
    @NotNull
    private List<Normalizer> normalizers = Normalizer.all();
    private boolean useThreshold = false;
    private double threshold = 0.9;

    protected ProfanityCheckerBuilder() {
    }

    @NotNull
    public ProfanityCheckerBuilder withLibraryPath(String libraryPath) {
        this.libraryPath = libraryPath;
        return this;
    }

    @NotNull
    public ProfanityCheckerBuilder withThresholdChecking(double threshold) {
        this.useThreshold = true;
        this.threshold = threshold;
        return this;
    }

    @NotNull
    public ProfanityCheckerBuilder withAutomaticChecking() {
        this.useThreshold = false;
        return this;
    }

    @NotNull
    public ProfanityCheckerBuilder withNormalizers(Normalizer ... normalizers) {
        this.normalizers = Arrays.asList(normalizers);
        return this;
    }

    @NotNull
    public ProfanityChecker build() {
        return new ProfanityChecker(this.libraryPath, this.normalizers, this.useThreshold, this.threshold);
    }
}

