/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.user;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.papiproxybridge.PAPIProxyBridge;
import net.william278.papiproxybridge.user.Request;

public interface OnlineUser {
    @NotNull
    public String getUsername();

    @NotNull
    public UUID getUniqueId();

    public void sendPluginMessage(@NotNull PAPIProxyBridge var1, @NotNull String var2, byte[] var3);

    default public void sendPluginMessage(@NotNull PAPIProxyBridge plugin, @NotNull Request request) {
        ByteArrayDataOutput messageWriter = ByteStreams.newDataOutput();
        messageWriter.writeUTF(this.getUsername());
        try (ByteArrayOutputStream messageByteStream = new ByteArrayOutputStream();
             DataOutputStream messageDataStream = new DataOutputStream(messageByteStream);){
            messageDataStream.writeUTF(request.toString());
            messageWriter.writeShort(messageByteStream.toByteArray().length);
            messageWriter.write(messageByteStream.toByteArray());
        }
        catch (IOException e) {
            plugin.log(Level.SEVERE, "Exception dispatching plugin message", e);
            return;
        }
        this.sendPluginMessage(plugin, plugin.getChannel(), messageWriter.toByteArray());
    }

    public void handlePluginMessage(@NotNull PAPIProxyBridge var1, @NotNull Request var2);
}

