/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.user;

import java.util.UUID;
import net.william278.huskchat.libraries.annotations.NotNull;

public final class Request {
    private final UUID uuid;
    private final UUID formatFor;
    private String message;

    public Request(@NotNull String message, @NotNull UUID formatFor) {
        this.uuid = UUID.randomUUID();
        this.formatFor = formatFor;
        this.message = message;
    }

    private Request(@NotNull UUID uuid, @NotNull UUID formatFor, @NotNull String message) {
        this.uuid = uuid;
        this.formatFor = formatFor;
        this.message = message;
    }

    public String toString() {
        return this.uuid.toString() + this.formatFor.toString() + this.message;
    }

    @NotNull
    public static Request fromString(@NotNull String string) {
        try {
            return new Request(UUID.fromString(string.substring(0, 36)), UUID.fromString(string.substring(36, 72)), string.substring(72));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid request string (is PAPIProxyBridge up-to-date on all servers and your proxy?): " + string);
        }
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public UUID getFormatFor() {
        return this.formatFor;
    }

    @NotNull
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@NotNull String message) {
        this.message = message;
    }
}

