/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.List;
import java.util.StringJoiner;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.message.ChatMessage;
import net.william278.huskchat.player.ConsolePlayer;
import net.william278.huskchat.player.Player;

public class ShortcutCommand
extends CommandBase {
    private final String channelId;

    public ShortcutCommand(@NotNull String command, @NotNull String channelId, @NotNull HuskChat plugin) {
        super(List.of(command), "[message]", plugin);
        this.channelId = channelId;
    }

    @Override
    public void onExecute(@NotNull Player player, @NotNull String[] args) {
        if (player.hasPermission(this.getPermission())) {
            if (args.length == 0) {
                if (player instanceof ConsolePlayer) {
                    this.plugin.getLocales().sendMessage(player, "error_console_switch_channels", new String[0]);
                    return;
                }
                this.plugin.getPlayerCache().switchPlayerChannel(player, this.channelId);
            } else {
                StringJoiner message = new StringJoiner(" ");
                for (String arg : args) {
                    message.add(arg);
                }
                Channel channel = this.plugin.getSettings().getChannels().get(this.channelId);
                if (channel.getBroadcastScope().isPassThrough) {
                    this.plugin.getLocales().sendMessage(player, "error_passthrough_shortcut_command", new String[0]);
                    return;
                }
                new ChatMessage(this.channelId, player, message.toString(), this.plugin).dispatch();
            }
        } else {
            this.plugin.getLocales().sendMessage(player, "error_no_permission", new String[0]);
        }
    }

    @Override
    @NotNull
    public String getPermission() {
        return "huskchat.command.channel";
    }

    @Override
    public List<String> onTabComplete(@NotNull Player player, @NotNull String[] args) {
        return List.of();
    }
}

