/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.player;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.boostedyaml.YamlDocument;
import net.william278.huskchat.libraries.boostedyaml.block.implementation.Section;
import net.william278.huskchat.player.Player;

public class PlayerCache {
    private final HuskChat plugin;
    private final Map<UUID, String> playerChannels;
    private final HashMap<UUID, SpyColor> localSpies = new HashMap();
    private final HashMap<UUID, SpyColor> socialSpies = new HashMap();
    @NotNull
    private static final Map<UUID, Set<UUID>> lastMessagePlayers = new HashMap<UUID, Set<UUID>>();

    public PlayerCache(@NotNull HuskChat plugin) {
        this.plugin = plugin;
        this.playerChannels = new LinkedHashMap<UUID, String>();
        try {
            YamlDocument spies = YamlDocument.create(new File(plugin.getDataFolder(), "spies.yml"));
            if (spies.contains("local")) {
                Section local = spies.getSection("local");
                for (Object name : local.getKeys()) {
                    this.localSpies.put(UUID.fromString(name.toString()), SpyColor.valueOf(local.getSection(name.toString()).getString("color")));
                }
            }
            if (spies.contains("social")) {
                Section social = spies.getSection("social");
                for (Object name : social.getKeys()) {
                    this.socialSpies.put(UUID.fromString(name.toString()), SpyColor.valueOf(social.getSection(name.toString()).getString("color")));
                }
            }
        }
        catch (IOException e) {
            plugin.log(Level.WARNING, "Error loading spy data", e);
        }
    }

    public String getPlayerChannel(UUID uuid) {
        if (!this.playerChannels.containsKey(uuid)) {
            return this.plugin.getSettings().getDefaultChannel();
        }
        return this.playerChannels.get(uuid);
    }

    public void setPlayerChannel(UUID uuid, String playerChannel) {
        this.playerChannels.put(uuid, playerChannel);
    }

    public void switchPlayerChannel(@NotNull Player player, @NotNull String channelID) {
        Channel channel = this.plugin.getSettings().getChannels().get(channelID);
        if (channel == null) {
            this.plugin.getLocales().sendMessage(player, "error_invalid_channel", new String[0]);
            return;
        }
        if (channel.getSendPermission() != null && !player.hasPermission(channel.getSendPermission())) {
            this.plugin.getLocales().sendMessage(player, "error_no_permission_send", channel.getId());
            return;
        }
        this.setPlayerChannel(player.getUuid(), channel.getId());
        this.plugin.getLocales().sendMessage(player, "channel_switched", channel.getId());
    }

    public static Optional<Set<UUID>> getLastMessengers(@NotNull UUID uuid) {
        if (lastMessagePlayers.containsKey(uuid)) {
            return Optional.of(lastMessagePlayers.get(uuid));
        }
        return Optional.empty();
    }

    public static void setLastMessenger(@NotNull UUID playerToSet, @NotNull List<Player> lastMessengers) {
        HashSet<UUID> uuidPlayers = new HashSet<UUID>();
        for (Player player : lastMessengers) {
            uuidPlayers.add(player.getUuid());
        }
        lastMessagePlayers.put(playerToSet, uuidPlayers);
    }

    public boolean isSocialSpying(@NotNull Player player) {
        return this.socialSpies.containsKey(player.getUuid());
    }

    public void setSocialSpy(@NotNull Player player) throws IOException {
        this.socialSpies.put(player.getUuid(), SpyColor.DEFAULT_SPY_COLOR);
        this.addSpy("social", player.getUuid(), SpyColor.DEFAULT_SPY_COLOR);
    }

    public void setSocialSpy(@NotNull Player player, @NotNull SpyColor spyColor) throws IOException {
        this.socialSpies.put(player.getUuid(), spyColor);
        this.addSpy("social", player.getUuid(), spyColor);
    }

    public void removeSocialSpy(@NotNull Player player) throws IOException {
        this.socialSpies.remove(player.getUuid());
        this.removeSpy("social", player.getUuid());
    }

    @NotNull
    public Map<Player, SpyColor> getSocialSpyMessageReceivers(@NotNull List<Player> messageRecipients) {
        LinkedHashMap<Player, SpyColor> receivers = new LinkedHashMap<Player, SpyColor>();
        block0: for (UUID player : this.socialSpies.keySet()) {
            SpyColor color = this.socialSpies.get(player);
            Optional<Player> spy = this.plugin.getPlayer(player);
            if (spy.isEmpty()) continue;
            for (Player messageRecipient : messageRecipients) {
                if (!player.equals(messageRecipient.getUuid())) continue;
                continue block0;
            }
            receivers.put(spy.get(), color);
        }
        return receivers;
    }

    public boolean isLocalSpying(Player player) {
        return this.localSpies.containsKey(player.getUuid());
    }

    public void setLocalSpy(Player player) throws IOException {
        this.localSpies.put(player.getUuid(), SpyColor.DEFAULT_SPY_COLOR);
        this.addSpy("local", player.getUuid(), SpyColor.DEFAULT_SPY_COLOR);
    }

    public void setLocalSpy(Player player, SpyColor spyColor) throws IOException {
        this.localSpies.put(player.getUuid(), spyColor);
        this.addSpy("local", player.getUuid(), spyColor);
    }

    public void removeLocalSpy(Player player) throws IOException {
        this.localSpies.remove(player.getUuid());
        this.removeSpy("local", player.getUuid());
    }

    @NotNull
    public Map<Player, SpyColor> getLocalSpyMessageReceivers(String localMessageServer, HuskChat implementor) {
        LinkedHashMap<Player, SpyColor> receivers = new LinkedHashMap<Player, SpyColor>();
        for (UUID player : this.localSpies.keySet()) {
            SpyColor color = this.localSpies.get(player);
            Optional<Player> spy = implementor.getPlayer(player);
            if (spy.isEmpty() || spy.get().getServerName().equals(localMessageServer)) continue;
            receivers.put(spy.get(), color);
        }
        return receivers;
    }

    public void addSpy(String type, UUID uuid, SpyColor spyColor) throws IOException {
        if (!type.equals("local") && !type.equals("social")) {
            return;
        }
        YamlDocument spies = YamlDocument.create(new File(this.plugin.getDataFolder(), "spies.yml"));
        if (!spies.contains(type)) {
            spies.createSection(type);
        }
        if (!spies.getSection(type).contains(uuid.toString())) {
            spies.getSection(type).createSection(uuid.toString());
        }
        spies.getSection(type).getSection(uuid.toString()).set("color", (Object)spyColor.toString());
        spies.save();
    }

    public void removeSpy(String type, UUID uuid) throws IOException {
        if (!type.equals("local") && !type.equals("social")) {
            return;
        }
        YamlDocument spies = YamlDocument.create(new File(this.plugin.getDataFolder(), "spies.yml"));
        if (!spies.contains(type)) {
            return;
        }
        if (!spies.getSection(type).contains(uuid.toString())) {
            return;
        }
        spies.getSection(type).remove(uuid.toString());
        if (spies.getSection(type).getKeys().size() == 0) {
            spies.remove(type);
        }
        spies.save();
    }

    public static enum SpyColor {
        DARK_RED("&4"),
        RED("&c"),
        GOLD("&6"),
        YELLOW("&e"),
        DARK_GREEN("&2"),
        GREEN("&a"),
        AQUA("&b"),
        DARK_AQUA("&3"),
        DARK_BLUE("&1"),
        BLUE("&9"),
        LIGHT_PURPLE("&d"),
        DARK_PURPLE("&5"),
        WHITE("&f"),
        GRAY("&7"),
        DARK_GRAY("&8"),
        BLACK("&9");

        public static final SpyColor DEFAULT_SPY_COLOR;
        public final String colorCode;

        private SpyColor(String colorCode) {
            this.colorCode = colorCode;
        }

        @NotNull
        public static List<String> getColorStrings() {
            ArrayList<String> colors = new ArrayList<String>();
            for (SpyColor color : SpyColor.values()) {
                colors.add(color.name().toLowerCase());
            }
            return colors;
        }

        public static Optional<SpyColor> getColor(@NotNull String colorInput) {
            for (SpyColor color : SpyColor.values()) {
                if (!color.colorCode.replace("&", "").equals(colorInput.replace("&", "")) && !color.name().equalsIgnoreCase(colorInput.toUpperCase())) continue;
                return Optional.of(color);
            }
            return Optional.empty();
        }

        static {
            DEFAULT_SPY_COLOR = DARK_GRAY;
        }
    }
}

