/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.papiproxybridge.user.OnlineUser;
import net.william278.papiproxybridge.user.Request;

public interface PAPIProxyBridge {
    @NotNull
    default public String getChannel() {
        return this.getChannelNamespace() + ":" + this.getChannelKey();
    }

    @NotNull
    default public String getChannelNamespace() {
        return "papiproxybridge";
    }

    @NotNull
    default public String getChannelKey() {
        return "format";
    }

    public Optional<OnlineUser> findPlayer(@NotNull UUID var1);

    public Optional<OnlineUser> findPlayer(@NotNull String var1);

    default public void handlePluginMessage(@NotNull PAPIProxyBridge plugin, @NotNull String channel, byte[] message) {
        if (!channel.equals(plugin.getChannel())) {
            return;
        }
        ByteArrayDataInput inputStream = ByteStreams.newDataInput((byte[])message);
        String username = inputStream.readUTF();
        OnlineUser user = plugin.findPlayer(username).orElse(null);
        if (user == null) {
            return;
        }
        short messageLength = inputStream.readShort();
        byte[] messageBody = new byte[messageLength];
        inputStream.readFully(messageBody);
        try (DataInputStream messageReader = new DataInputStream(new ByteArrayInputStream(messageBody));){
            user.handlePluginMessage(plugin, Request.fromString(messageReader.readUTF()));
        }
        catch (Exception e) {
            plugin.log(Level.SEVERE, "Failed to fully read plugin message", e);
        }
    }

    public CompletableFuture<String> createRequest(@NotNull String var1, @NotNull OnlineUser var2, @NotNull UUID var3);

    public void log(@NotNull Level var1, @NotNull String var2, Throwable ... var3);
}

