/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.api;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.jodah.expiringmap.ExpiringMap;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.papiproxybridge.PAPIProxyBridge;
import net.william278.papiproxybridge.user.OnlineUser;

public final class PlaceholderAPI {
    private static PlaceholderAPI instance;
    private final PAPIProxyBridge plugin;
    private final Map<UUID, ExpiringMap<String, String>> cache;
    private long requestTimeout = 400L;
    private long cacheExpiry = 30000L;

    private PlaceholderAPI(@NotNull PAPIProxyBridge plugin) {
        this.plugin = plugin;
        this.cache = new HashMap<UUID, ExpiringMap<String, String>>();
    }

    @NotNull
    public static PlaceholderAPI getInstance() {
        if (instance == null) {
            throw new IllegalStateException("ProxyPlaceholderApi is not initialized");
        }
        return instance;
    }

    public static void register(@NotNull PAPIProxyBridge plugin) {
        instance = new PlaceholderAPI(plugin);
    }

    public CompletableFuture<String> formatPlaceholders(@NotNull String text, @NotNull OnlineUser requester, @NotNull UUID formatFor) {
        if (this.cacheExpiry > 0L && this.cache.containsKey(formatFor) && this.cache.get(formatFor).containsKey((Object)text)) {
            return CompletableFuture.completedFuture((String)this.cache.get(formatFor).get((Object)text));
        }
        return ((CompletableFuture)this.plugin.createRequest(text, requester, formatFor).thenApply(formatted -> {
            this.cache.computeIfAbsent(requester.getUniqueId(), uuid -> ExpiringMap.builder().expiration(this.cacheExpiry, TimeUnit.MILLISECONDS).build()).put((Object)text, formatted);
            return formatted;
        })).orTimeout(this.requestTimeout, TimeUnit.MILLISECONDS).exceptionally(throwable -> text);
    }

    public CompletableFuture<String> formatPlaceholders(@NotNull String text, @NotNull OnlineUser player) {
        return this.formatPlaceholders(text, player, player.getUniqueId());
    }

    public CompletableFuture<String> formatPlaceholders(@NotNull String text, @NotNull UUID requester, @NotNull UUID formatFor) {
        return this.plugin.findPlayer(requester).map(onlineRequester -> this.formatPlaceholders(text, (OnlineUser)onlineRequester, formatFor)).orElse(CompletableFuture.completedFuture(text));
    }

    public CompletableFuture<String> formatPlaceholders(@NotNull String text, @NotNull UUID player) {
        return this.plugin.findPlayer(player).map(requester -> this.formatPlaceholders(text, (OnlineUser)requester, player)).orElse(CompletableFuture.completedFuture(text));
    }

    public void setRequestTimeout(long requestTimeout) {
        if (requestTimeout < 0L) {
            throw new IllegalArgumentException("Request timeout cannot be negative");
        }
        this.requestTimeout = requestTimeout;
    }

    public void setCacheExpiry(long cacheExpiry) {
        if (cacheExpiry < 0L) {
            throw new IllegalArgumentException("Cache expiry cannot be negative");
        }
        this.cacheExpiry = cacheExpiry;
    }
}

