/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.message.PrivateMessage;
import net.william278.huskchat.player.ConsolePlayer;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;

public class ReplyCommand
extends CommandBase {
    public ReplyCommand(@NotNull HuskChat plugin) {
        super(plugin.getSettings().getReplyCommandAliases(), "<message>", plugin);
    }

    @Override
    public void onExecute(@NotNull Player player, @NotNull String[] args) {
        if (player.hasPermission(this.getPermission())) {
            if (args.length >= 1) {
                Optional<Set<UUID>> lastMessengers = PlayerCache.getLastMessengers(player.getUuid());
                if (lastMessengers.isEmpty()) {
                    this.plugin.getLocales().sendMessage(player, "error_reply_no_messages", new String[0]);
                    return;
                }
                ArrayList<String> lastPlayers = new ArrayList<String>();
                for (UUID uUID : lastMessengers.get()) {
                    if (ConsolePlayer.isConsolePlayer(uUID)) {
                        lastPlayers.add(ConsolePlayer.create(this.plugin).getName());
                        continue;
                    }
                    this.plugin.getPlayer(uUID).ifPresent(onlineMessenger -> lastPlayers.add(onlineMessenger.getName()));
                }
                if (lastPlayers.isEmpty()) {
                    if (lastMessengers.get().size() > 1) {
                        this.plugin.getLocales().sendMessage(player, "error_reply_none_online", new String[0]);
                    } else {
                        this.plugin.getLocales().sendMessage(player, "error_reply_not_online", new String[0]);
                    }
                    return;
                }
                StringJoiner message = new StringJoiner(" ");
                for (String arg : args) {
                    message.add(arg);
                }
                String string = message.toString();
                new PrivateMessage(player, lastPlayers, string, this.plugin).dispatch();
            } else {
                this.plugin.getLocales().sendMessage(player, "error_invalid_syntax", this.getUsage());
            }
        } else {
            this.plugin.getLocales().sendMessage(player, "error_no_permission", new String[0]);
        }
    }

    @Override
    @NotNull
    public String getPermission() {
        return "huskchat.command.msg.reply";
    }

    @Override
    public List<String> onTabComplete(@NotNull Player player, @NotNull String[] args) {
        return List.of();
    }
}

