/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.config;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.message.ChatMessage;

public class Webhook {
    private final HuskChat plugin;

    private Optional<URL> getWebhookUrl(@NotNull String channelId) {
        Map<String, URL> urls = this.plugin.getSettings().getWebhookUrls();
        if (urls.containsKey(channelId)) {
            return Optional.of(urls.get(channelId));
        }
        return Optional.empty();
    }

    public Webhook(@NotNull HuskChat plugin) {
        this.plugin = plugin;
    }

    public void dispatchWebhook(@NotNull ChatMessage message) {
        CompletableFuture.runAsync(() -> this.getWebhookUrl(message.targetChannelId).ifPresent(webhookUrl -> {
            try {
                HttpURLConnection webhookConnection = (HttpURLConnection)webhookUrl.openConnection();
                webhookConnection.setRequestMethod("POST");
                webhookConnection.setDoOutput(true);
                byte[] jsonMessage = this.getChatMessageJson(this.plugin.getSettings().getWebhookMessageFormat(), message);
                int messageLength = jsonMessage.length;
                webhookConnection.setFixedLengthStreamingMode(messageLength);
                webhookConnection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                webhookConnection.connect();
                try (OutputStream messageOutputStream = webhookConnection.getOutputStream();){
                    messageOutputStream.write(jsonMessage);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
    }

    private byte[] getChatMessageJson(@NotNull Format format, @NotNull ChatMessage message) {
        return format.getPostMessageFormat(this.plugin).replace("{SENDER_UUID}", message.sender.getUuid().toString()).replace("{SENDER_CHANNEL}", message.targetChannelId).replace("{CURRENT_TIMESTAMP}", ZonedDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME)).replace("{SENDER_USERNAME}", message.sender.getName()).replace("{CHAT_MESSAGE}", message.message.replace("\\", "\\\\").replace("\"", "\\\"")).getBytes(StandardCharsets.UTF_8);
    }

    public static enum Format {
        EMBEDDED,
        INLINE;


        public static Optional<Format> getMessageFormat(@NotNull String formatName) {
            for (Format format : Format.values()) {
                if (!format.name().equalsIgnoreCase(formatName)) continue;
                return Optional.of(format);
            }
            return Optional.empty();
        }

        @NotNull
        public String getPostMessageFormat(@NotNull HuskChat plugin) {
            try {
                return new String(plugin.getResource("discord/" + this.name().toLowerCase(Locale.ENGLISH) + "_message.json").readAllBytes(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to load \"" + this.name() + "\" Discord message format", e);
            }
        }
    }
}

