/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.config.Webhook;
import net.william278.huskchat.filter.AdvertisingFilterer;
import net.william278.huskchat.filter.AsciiFilter;
import net.william278.huskchat.filter.CapsFilter;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.filter.ProfanityFilterer;
import net.william278.huskchat.filter.RepeatFilter;
import net.william278.huskchat.filter.SpamFilter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.boostedyaml.YamlDocument;
import net.william278.huskchat.libraries.boostedyaml.block.implementation.Section;
import net.william278.huskchat.replacer.EmojiReplacer;

public class Settings {
    private String language;
    private boolean checkForUpdates;
    private boolean doPlaceholderAPI;
    private long papiProxyBridgeCacheTime;
    private String defaultChannel;
    private HashMap<String, String> serverDefaultChannels;
    private HashMap<String, Channel> channels;
    private String channelLogFormat;
    private List<String> channelCommandAliases;
    private boolean doMessageCommand;
    private boolean doGroupMessages;
    private int maxGroupMessageSize;
    private List<String> messageCommandAliases;
    private List<String> replyCommandAliases;
    private String inboundMessageFormat;
    private String outboundMessageFormat;
    private String groupInboundMessageFormat;
    private String groupOutboundMessageFormat;
    private boolean logPrivateMessages;
    private boolean censorPrivateMessages;
    private String messageLogFormat;
    private List<String> messageCommandRestrictedServers;
    private boolean doSocialSpyCommand;
    private String socialSpyFormat;
    private String socialSpyGroupFormat;
    private List<String> socialSpyCommandAliases;
    private boolean doLocalSpyCommand;
    private String localSpyFormat;
    private List<String> excludedLocalSpyChannels;
    private List<String> localSpyCommandAliases;
    private boolean doBroadcastCommand;
    private List<String> broadcastCommandAliases;
    private String broadcastMessageFormat;
    private boolean logBroadcasts;
    private String broadcastLogFormat;
    private Map<String, List<ChatFilter>> chatFilters;
    private boolean doDiscordIntegration;
    private Map<String, URL> webhookUrls;
    private Webhook.Format webhookFormat;
    private Map<String, String> serverNameReplacement;

    public Settings(@NotNull YamlDocument configFile) {
        this.loadConfig(configFile);
    }

    private void loadConfig(@NotNull YamlDocument configFile) {
        this.language = configFile.getString("language", "en-gb");
        this.checkForUpdates = configFile.getBoolean("check_for_updates", (Boolean)true);
        this.doPlaceholderAPI = configFile.getBoolean("placeholders.use_papi", (Boolean)true);
        this.papiProxyBridgeCacheTime = configFile.getLong("placeholders.cache_time", (Long)1000L);
        this.defaultChannel = configFile.getString("default_channel", "global");
        this.channelLogFormat = configFile.getString("channel_log_format", "[CHAT] [%channel%] %sender%: ");
        this.channels = new LinkedHashMap<String, Channel>();
        this.channels.putAll(this.fetchChannels(configFile));
        this.serverDefaultChannels = this.getServerDefaultChannels(configFile);
        this.channelCommandAliases = configFile.contains("channel_command_aliases") ? this.getCommandsFromList(configFile.getStringList("channel_command_aliases")) : Collections.singletonList("channel");
        this.doMessageCommand = configFile.getBoolean("message_command.enabled", (Boolean)true);
        this.doGroupMessages = configFile.getBoolean("message_command.group_messages.enabled", (Boolean)true);
        this.maxGroupMessageSize = configFile.getInt("message_command.group_messages.max_size", (Integer)5);
        this.inboundMessageFormat = configFile.getString("message_command.format.inbound", "&#00fb9a&%name% &8\u2192 &#00fb9a&You&8: &f");
        this.outboundMessageFormat = configFile.getString("message_command.format.outbound", "&#00fb9a&You &8\u2192 &#00fb9a&%name%&8 &f");
        this.groupInboundMessageFormat = configFile.getString("message_command.format.group_inbound", "&#00fb9a&%name% &8\u2192 &#00fb9a&You[\u208d\u208a%group_amount_subscript%\u208e](gray show_text=&7%group_members%)&8: &f");
        this.groupOutboundMessageFormat = configFile.getString("message_command.format.group_outbound", "&#00fb9a&You &8\u2192 &#00fb9a&%name%[\u208d\u208a%group_amount_subscript%\u208e](gray show_text=&7%group_members%)&8: &f");
        this.logPrivateMessages = configFile.getBoolean("message_command.log_to_console", (Boolean)true);
        this.censorPrivateMessages = configFile.getBoolean("message_command.censor", (Boolean)false);
        this.messageLogFormat = configFile.getString("message_command.log_format", "[MSG] [%sender% -> %receiver%]: ");
        this.messageCommandRestrictedServers = configFile.getStringList("message_command.restricted_servers");
        this.messageCommandAliases = configFile.contains("message_command.msg_aliases") ? this.getCommandsFromList(configFile.getStringList("message_command.msg_aliases")) : Collections.singletonList("msg");
        this.replyCommandAliases = new ArrayList<String>();
        this.replyCommandAliases = configFile.contains("message_command.reply_aliases") ? this.getCommandsFromList(configFile.getStringList("message_command.reply_aliases")) : Collections.singletonList("reply");
        this.doSocialSpyCommand = configFile.getBoolean("social_spy.enabled", (Boolean)true);
        this.socialSpyFormat = configFile.getString("social_spy.format", "&e[Spy] &7%sender% &8\u2192 &7%receiver%:%spy_color% ");
        this.socialSpyGroupFormat = configFile.getString("social_spy.group_format", "&e[Spy] &7%sender_name% &8\u2192 &7%receiver_name%[\u208d\u208a%group_amount_subscript%\u208e](gray show_text=&7%group_members%):%spy_color% ");
        this.socialSpyCommandAliases = configFile.contains("social_spy.socialspy_aliases") ? this.getCommandsFromList(configFile.getStringList("social_spy.socialspy_aliases")) : Collections.singletonList("socialspy");
        this.doLocalSpyCommand = configFile.getBoolean("local_spy.enabled", (Boolean)true);
        this.localSpyFormat = configFile.getString("local_spy.format", "&e[Spy] &7[%channel%] %name%&8:%spy_color% ");
        this.excludedLocalSpyChannels = configFile.contains("local_spy.excluded_local_channels") ? configFile.getStringList("local_spy.excluded_local_channels") : new ArrayList();
        this.localSpyCommandAliases = configFile.contains("local_spy.localspy_aliases") ? this.getCommandsFromList(configFile.getStringList("local_spy.localspy_aliases")) : Collections.singletonList("localspy");
        this.doBroadcastCommand = configFile.getBoolean("broadcast_command.enabled", (Boolean)true);
        this.broadcastCommandAliases = configFile.contains("broadcast_command.broadcast_aliases") ? this.getCommandsFromList(configFile.getStringList("broadcast_command.broadcast_aliases")) : Collections.singletonList("broadcast");
        this.broadcastMessageFormat = configFile.getString("broadcast_command.format", "&6[Broadcast]&e ");
        this.logBroadcasts = configFile.getBoolean("broadcast_command.log_to_console", (Boolean)true);
        this.broadcastLogFormat = configFile.getString("broadcast_command.log_format", "[BROADCAST]: ");
        this.chatFilters = this.fetchChatFilters(configFile);
        this.doDiscordIntegration = configFile.getBoolean("discord.enabled", (Boolean)false);
        this.webhookFormat = Webhook.Format.getMessageFormat(configFile.getString("discord.format_style", "inline")).orElse(Webhook.Format.INLINE);
        this.webhookUrls = this.fetchWebhookUrls(configFile);
        this.serverNameReplacement = new LinkedHashMap<String, String>();
        Section serverNameReplacementSection = configFile.getSection("server_name_replacement");
        if (serverNameReplacementSection != null) {
            for (String s : serverNameReplacementSection.getRoutesAsStrings(false)) {
                this.serverNameReplacement.put(s, serverNameReplacementSection.getString(s));
            }
        }
    }

    private HashMap<String, Channel> fetchChannels(YamlDocument configFile) throws IllegalArgumentException {
        HashMap<String, Channel> channels = new HashMap<String, Channel>();
        for (String channelID : configFile.getSection("channels").getRoutesAsStrings(false)) {
            String format = configFile.getString("channels." + channelID + ".format", "%fullname%&r: ");
            String broadcastScope = configFile.getString("channels." + channelID + ".broadcast_scope", "GLOBAL").toUpperCase();
            Channel channel = new Channel(channelID.toLowerCase(), format, Channel.BroadcastScope.valueOf(broadcastScope));
            if (configFile.contains("channels." + channelID + ".shortcut_commands")) {
                channel.setShortcutCommands(this.getCommandsFromList(configFile.getStringList("channels." + channelID + ".shortcut_commands")));
            }
            if (configFile.contains("channels." + channelID + ".restricted_servers")) {
                channel.setRestrictedServers(configFile.getStringList("channels." + channelID + ".restricted_servers"));
            }
            channel.setSendPermission(configFile.getString("channels." + channelID + ".permissions.send", null));
            channel.setReceivePermission(configFile.getString("channels." + channelID + ".permissions.receive", null));
            channel.setLogMessages(configFile.getBoolean("channels." + channelID + ".log_to_console", (Boolean)true));
            channel.setFilter(configFile.getBoolean("channels." + channelID + ".filtered", (Boolean)true));
            channels.put(channelID, channel);
        }
        return channels;
    }

    private Map<String, List<ChatFilter>> fetchChatFilters(YamlDocument configFile) {
        List<String> channels;
        HashMap<String, List<ChatFilter>> filters = new HashMap<String, List<ChatFilter>>();
        this.clearChatFilters();
        for (String string : configFile.getSection("channels").getRoutesAsStrings(false)) {
            filters.put(string, new ArrayList());
        }
        filters.put("private_messages", new ArrayList());
        filters.put("broadcast_messages", new ArrayList());
        if (configFile.getBoolean("chat_filters.advertising_filter.enabled", (Boolean)true).booleanValue()) {
            channels = configFile.getStringList("chat_filters.advertising_filter.channels");
            if (configFile.getBoolean("chat_filters.advertising_filter.private_messages", (Boolean)false).booleanValue()) {
                channels.add("private_messages");
            }
            if (configFile.getBoolean("chat_filters.advertising_filter.broadcast_messages", (Boolean)false).booleanValue()) {
                channels.add("broadcast_messages");
            }
            for (String string : channels) {
                if (!filters.containsKey(string)) continue;
                ((List)filters.get(string)).add(new AdvertisingFilterer());
            }
        }
        if (configFile.getBoolean("chat_filters.caps_filter.enabled", (Boolean)true).booleanValue()) {
            channels = configFile.getStringList("chat_filters.caps_filter.channels");
            if (configFile.getBoolean("chat_filters.caps_filter.private_messages", (Boolean)false).booleanValue()) {
                channels.add("private_messages");
            }
            if (configFile.getBoolean("chat_filters.caps_filter.broadcast_messages", (Boolean)false).booleanValue()) {
                channels.add("broadcast_messages");
            }
            for (String string : channels) {
                if (!filters.containsKey(string)) continue;
                ((List)filters.get(string)).add(new CapsFilter(configFile.getDouble("chat_filters.caps_filter.max_caps_percentage", (Double)0.4)));
            }
        }
        if (configFile.getBoolean("chat_filters.spam_filter.enabled", (Boolean)true).booleanValue()) {
            channels = configFile.getStringList("chat_filters.spam_filter.channels");
            if (configFile.getBoolean("chat_filters.spam_filter.private_messages", (Boolean)false).booleanValue()) {
                channels.add("private_messages");
            }
            if (configFile.getBoolean("chat_filters.spam_filter.broadcast_messages", (Boolean)false).booleanValue()) {
                channels.add("broadcast_messages");
            }
            for (String string : channels) {
                if (!filters.containsKey(string)) continue;
                ((List)filters.get(string)).add(new SpamFilter(configFile.getInt("chat_filters.spam_filter.period_seconds", (Integer)4), configFile.getInt("chat_filters.spam_filter.messages_per_period", (Integer)3)));
            }
        }
        if (configFile.getBoolean("chat_filters.repeat_filter.enabled", (Boolean)true).booleanValue()) {
            channels = configFile.getStringList("chat_filters.repeat_filter.channels");
            if (configFile.getBoolean("chat_filters.repeat_filter.private_messages", (Boolean)false).booleanValue()) {
                channels.add("private_messages");
            }
            if (configFile.getBoolean("chat_filters.repeat_filter.broadcast_messages", (Boolean)false).booleanValue()) {
                channels.add("broadcast_messages");
            }
            for (String string : channels) {
                if (!filters.containsKey(string)) continue;
                ((List)filters.get(string)).add(new RepeatFilter(configFile.getInt("chat_filters.repeat_filter.previous_messages_to_check", (Integer)2)));
            }
        }
        if (configFile.getBoolean("chat_filters.profanity_filter.enabled", (Boolean)false).booleanValue()) {
            channels = configFile.getStringList("chat_filters.profanity_filter.channels");
            if (configFile.getBoolean("chat_filters.profanity_filter.private_messages", (Boolean)false).booleanValue()) {
                channels.add("private_messages");
            }
            if (configFile.getBoolean("chat_filters.profanity_filter.broadcast_messages", (Boolean)false).booleanValue()) {
                channels.add("broadcast_messages");
            }
            for (String string : channels) {
                if (!filters.containsKey(string)) continue;
                ((List)filters.get(string)).add(new ProfanityFilterer(ProfanityFilterer.ProfanityFilterMode.valueOf(configFile.getString("chat_filters.profanity_filter.mode", "TOLERANCE").toUpperCase()), configFile.getDouble("chat_filters.profanity_filter.tolerance", (Double)0.78), configFile.getString("chat_filters.profanity_filter.library_path", "")));
            }
        }
        if (configFile.getBoolean("chat_filters.ascii_filter.enabled", (Boolean)false).booleanValue()) {
            channels = configFile.getStringList("chat_filters.ascii_filter.channels");
            if (configFile.getBoolean("chat_filters.ascii_filter.private_messages", (Boolean)false).booleanValue()) {
                channels.add("private_messages");
            }
            if (configFile.getBoolean("chat_filters.ascii_filter.broadcast_messages", (Boolean)false).booleanValue()) {
                channels.add("broadcast_messages");
            }
            for (String string : channels) {
                if (!filters.containsKey(string)) continue;
                ((List)filters.get(string)).add(new AsciiFilter());
            }
        }
        if (configFile.getBoolean("message_replacers.emoji_replacer.enabled", (Boolean)true).booleanValue()) {
            HashMap<String, String> emojiSequences = new HashMap<String, String>();
            boolean bl = configFile.getBoolean("message_replacers.emoji_replacer.case_insensitive", (Boolean)false);
            for (String characters : configFile.getSection("message_replacers.emoji_replacer.emoji").getRoutesAsStrings(false)) {
                if (!bl) {
                    emojiSequences.put(characters, configFile.getString("message_replacers.emoji_replacer.emoji." + characters));
                    continue;
                }
                emojiSequences.put(characters.toLowerCase(Locale.ROOT), configFile.getString("message_replacers.emoji_replacer.emoji." + characters));
            }
            List<String> list = configFile.getStringList("message_replacers.emoji_replacer.channels");
            if (configFile.getBoolean("chat_filters.emoji_replacer.private_messages", (Boolean)true).booleanValue()) {
                list.add("private_messages");
            }
            if (configFile.getBoolean("chat_filters.emoji_replacer.broadcast_messages", (Boolean)true).booleanValue()) {
                list.add("broadcast_messages");
            }
            for (String channel : list) {
                if (!filters.containsKey(channel)) continue;
                ((List)filters.get(channel)).add(new EmojiReplacer(emojiSequences, bl));
            }
        }
        return filters;
    }

    private Map<String, URL> fetchWebhookUrls(@NotNull YamlDocument configFile) {
        HashMap<String, URL> webhookUrls = new HashMap<String, URL>();
        try {
            if (configFile.contains("discord.channel_webhooks")) {
                for (String channelID : configFile.getSection("discord.channel_webhooks").getRoutesAsStrings(false)) {
                    if (!this.channels.containsKey(channelID)) continue;
                    webhookUrls.put(channelID, new URL(configFile.getString("discord.channel_webhooks." + channelID)));
                }
            }
        }
        catch (MalformedURLException e) {
            this.doDiscordIntegration = false;
        }
        return webhookUrls;
    }

    private HashMap<String, String> getServerDefaultChannels(YamlDocument configFile) {
        HashMap<String, String> serverDefaults = new HashMap<String, String>();
        if (configFile.contains("server_default_channels")) {
            for (String server : configFile.getSection("server_default_channels").getRoutesAsStrings(false)) {
                String channelId = configFile.getString("server_default_channels." + server);
                serverDefaults.put(server, channelId);
            }
        }
        return serverDefaults;
    }

    private List<String> getCommandsFromList(List<String> rawCommands) {
        ArrayList<String> commands = new ArrayList<String>();
        for (String command : rawCommands) {
            commands.add(command.substring(1));
        }
        return commands;
    }

    private void clearChatFilters() {
        this.chatFilters = new HashMap<String, List<ChatFilter>>();
    }

    public String[] getAliases(List<String> aliases) {
        if (aliases.size() <= 1) {
            return new String[0];
        }
        String[] aliasList = new String[aliases.size() - 1];
        for (int i = 1; i < aliases.size(); ++i) {
            aliasList[i - 1] = aliases.get(i);
        }
        return aliasList;
    }

    @NotNull
    public String getLanguage() {
        return this.language;
    }

    public boolean doCheckForUpdates() {
        return this.checkForUpdates;
    }

    public boolean doPlaceholderAPI() {
        return this.doPlaceholderAPI;
    }

    public long getPapiProxyBridgeCacheTime() {
        return this.papiProxyBridgeCacheTime;
    }

    @NotNull
    public String getDefaultChannel() {
        return this.defaultChannel;
    }

    @NotNull
    public Map<String, String> getServerDefaultChannels() {
        return this.serverDefaultChannels;
    }

    @NotNull
    public Map<String, Channel> getChannels() {
        return this.channels;
    }

    @NotNull
    public String getChannelLogFormat() {
        return this.channelLogFormat;
    }

    @NotNull
    public List<String> getChannelCommandAliases() {
        return this.channelCommandAliases;
    }

    public boolean isDoMessageCommand() {
        return this.doMessageCommand;
    }

    public boolean doGroupMessages() {
        return this.doGroupMessages;
    }

    public int getMaxGroupMessageSize() {
        return this.maxGroupMessageSize;
    }

    @NotNull
    public List<String> getMessageCommandAliases() {
        return this.messageCommandAliases;
    }

    @NotNull
    public List<String> getReplyCommandAliases() {
        return this.replyCommandAliases;
    }

    @NotNull
    public String getInboundMessageFormat() {
        return this.inboundMessageFormat;
    }

    @NotNull
    public String getOutboundMessageFormat() {
        return this.outboundMessageFormat;
    }

    @NotNull
    public String getGroupInboundMessageFormat() {
        return this.groupInboundMessageFormat;
    }

    @NotNull
    public String getGroupOutboundMessageFormat() {
        return this.groupOutboundMessageFormat;
    }

    public boolean doLogPrivateMessages() {
        return this.logPrivateMessages;
    }

    public boolean isCensorPrivateMessages() {
        return this.censorPrivateMessages;
    }

    @NotNull
    public String getMessageLogFormat() {
        return this.messageLogFormat;
    }

    @NotNull
    public List<String> getMessageCommandRestrictedServers() {
        return this.messageCommandRestrictedServers;
    }

    public boolean doSocialSpyCommand() {
        return this.doSocialSpyCommand;
    }

    @NotNull
    public String getSocialSpyFormat() {
        return this.socialSpyFormat;
    }

    @NotNull
    public String getSocialSpyGroupFormat() {
        return this.socialSpyGroupFormat;
    }

    @NotNull
    public List<String> getSocialSpyCommandAliases() {
        return this.socialSpyCommandAliases;
    }

    public boolean doLocalSpyCommand() {
        return this.doLocalSpyCommand;
    }

    @NotNull
    public String getLocalSpyFormat() {
        return this.localSpyFormat;
    }

    public boolean isLocalSpyChannelExcluded(@NotNull Channel channel) {
        for (String excludedChannel : this.excludedLocalSpyChannels) {
            if (!excludedChannel.equals(channel.getId())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<String> getLocalSpyCommandAliases() {
        return this.localSpyCommandAliases;
    }

    public boolean isDoBroadcastCommand() {
        return this.doBroadcastCommand;
    }

    @NotNull
    public List<String> getBroadcastCommandAliases() {
        return this.broadcastCommandAliases;
    }

    @NotNull
    public String getBroadcastMessageFormat() {
        return this.broadcastMessageFormat;
    }

    public boolean doLogBroadcasts() {
        return this.logBroadcasts;
    }

    @NotNull
    public String getBroadcastLogFormat() {
        return this.broadcastLogFormat;
    }

    @NotNull
    public Map<String, List<ChatFilter>> getChatFilters() {
        return this.chatFilters;
    }

    public boolean doDiscordIntegration() {
        return this.doDiscordIntegration;
    }

    public Map<String, URL> getWebhookUrls() {
        return this.webhookUrls;
    }

    public Webhook.Format getWebhookMessageFormat() {
        return this.webhookFormat;
    }

    public Map<String, String> getServerNameReplacement() {
        return this.serverNameReplacement;
    }
}

