/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.bukkit.event;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.william278.huskchat.bukkit.BukkitHuskChat;
import net.william278.huskchat.bukkit.event.BroadcastMessageEvent;
import net.william278.huskchat.bukkit.event.ChatMessageEvent;
import net.william278.huskchat.bukkit.event.PrivateMessageEvent;
import net.william278.huskchat.event.EventDispatcher;
import net.william278.huskchat.event.IBroadcastMessageEvent;
import net.william278.huskchat.event.IChatMessageEvent;
import net.william278.huskchat.event.IPrivateMessageEvent;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class BukkitEventDispatcher
implements EventDispatcher {
    private final BukkitHuskChat plugin;

    public BukkitEventDispatcher(@NotNull BukkitHuskChat plugin) {
        this.plugin = plugin;
    }

    @Override
    public CompletableFuture<IChatMessageEvent> dispatchChatMessageEvent(@NotNull Player player, @NotNull String message, @NotNull String channelId) {
        CompletableFuture<IChatMessageEvent> completableFuture = new CompletableFuture<IChatMessageEvent>();
        ChatMessageEvent event = new ChatMessageEvent(player, message, channelId);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            completableFuture.complete(event);
        });
        return completableFuture;
    }

    @Override
    public CompletableFuture<IPrivateMessageEvent> dispatchPrivateMessageEvent(@NotNull Player sender, @NotNull List<Player> receivers, @NotNull String message) {
        CompletableFuture<IPrivateMessageEvent> completableFuture = new CompletableFuture<IPrivateMessageEvent>();
        PrivateMessageEvent event = new PrivateMessageEvent(sender, receivers, message);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            completableFuture.complete(event);
        });
        return completableFuture;
    }

    @Override
    public CompletableFuture<IBroadcastMessageEvent> dispatchBroadcastMessageEvent(@NotNull Player sender, @NotNull String message) {
        CompletableFuture<IBroadcastMessageEvent> completableFuture = new CompletableFuture<IBroadcastMessageEvent>();
        BroadcastMessageEvent event = new BroadcastMessageEvent(sender, message);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            completableFuture.complete(event);
        });
        return completableFuture;
    }
}

