/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.filter;

import java.util.regex.Pattern;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.Player;

public class AsciiFilter
extends ChatFilter {
    private final Pattern asciiPattern = Pattern.compile("^[\\u0000-\\u007F]*$");

    @Override
    public boolean isAllowed(@NotNull Player player, @NotNull String message) {
        return this.asciiPattern.matcher(message).matches();
    }

    @Override
    @NotNull
    public String getFailureErrorMessageId() {
        return "error_chat_filter_ascii";
    }

    @Override
    @NotNull
    public String getFilterIgnorePermission() {
        return "huskchat.ignore_filters.ascii";
    }
}

