/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.placeholders;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.placeholders.PlaceholderReplacer;
import net.william278.huskchat.player.Player;

public class DefaultReplacer
implements PlaceholderReplacer {
    private final HuskChat plugin;

    public DefaultReplacer(@NotNull HuskChat plugin) {
        this.plugin = plugin;
    }

    @Override
    public CompletableFuture<String> formatPlaceholders(@NotNull String message, @NotNull Player player) {
        return Placeholder.replace(message, this.plugin, player);
    }

    public static enum Placeholder {
        NAME((plugin, player) -> plugin.getDataGetter().getPlayerName((Player)player), "username"),
        FULL_NAME((plugin, player) -> plugin.getDataGetter().getPlayerFullName((Player)player), "fullname"),
        PREFIX((plugin, player) -> plugin.getDataGetter().getPlayerPrefix((Player)player).isPresent() ? plugin.getDataGetter().getPlayerPrefix((Player)player).get() : "", "role_prefix", "roleprefix"),
        SUFFIX((plugin, player) -> plugin.getDataGetter().getPlayerSuffix((Player)player).isPresent() ? plugin.getDataGetter().getPlayerSuffix((Player)player).get() : "", "role_suffix", "rolesuffix"),
        ROLE((plugin, player) -> plugin.getDataGetter().getPlayerGroupName((Player)player).isPresent() ? plugin.getDataGetter().getPlayerGroupName((Player)player).get() : "", "role_name", "rolename"),
        ROLE_DISPLAY_NAME((plugin, player) -> plugin.getDataGetter().getPlayerGroupDisplayName((Player)player).isPresent() ? plugin.getDataGetter().getPlayerGroupDisplayName((Player)player).get() : "", "roledisplayname"),
        PING((plugin, player) -> Integer.toString(player.getPing()), new String[0]),
        UUID((plugin, player) -> player.getUuid().toString(), new String[0]),
        SERVER((plugin, player) -> plugin.getSettings().getServerNameReplacement().getOrDefault(player.getServerName(), player.getServerName()), "server_name", "servername"),
        LOCAL_PLAYERS_ONLINE((plugin, player) -> Integer.toString(player.getPlayersOnServer()), "server_player_count", "serverplayercount"),
        TIMESTAMP((plugin, player) -> new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()), "timestamp"),
        CURRENT_TIME((plugin, player) -> new SimpleDateFormat("HH:mm:ss").format(new Date()), "time"),
        CURRENT_TIME_SHORT((plugin, player) -> new SimpleDateFormat("HH:mm").format(new Date()), "short_time"),
        CURRENT_DATE((plugin, player) -> new SimpleDateFormat("yyyy/MM/dd").format(new Date()), "date"),
        CURRENT_DATE_UK((plugin, player) -> new SimpleDateFormat("dd/MM/yyyy").format(new Date()), "british_date"),
        CURRENT_DATE_DAY((plugin, player) -> new SimpleDateFormat("dd").format(new Date()), "day"),
        CURRENT_MONTH((plugin, player) -> new SimpleDateFormat("MM").format(new Date()), "month"),
        CURRENT_YEAR((plugin, player) -> new SimpleDateFormat("yyyy").format(new Date()), "year");

        private final BiFunction<HuskChat, Player, String> replacer;
        private final Set<String> aliases = new HashSet<String>();

        private Placeholder(BiFunction<HuskChat, Player, String> replacer, String ... aliases) {
            this.replacer = replacer;
            this.aliases.add(this.name().toLowerCase(Locale.ENGLISH));
            this.aliases.addAll(Set.of(aliases));
        }

        private static CompletableFuture<String> replace(@NotNull String format, @NotNull HuskChat plugin, @NotNull Player player) {
            for (Placeholder placeholder : Placeholder.values()) {
                for (String alias : placeholder.aliases) {
                    format = format.replace("%" + alias + "%", placeholder.replacer.apply(plugin, player));
                }
            }
            return CompletableFuture.completedFuture(Placeholder.escape(format));
        }

        @NotNull
        private static String escape(@NotNull String string) {
            return string.replace("__", "_\\_");
        }
    }
}

