/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.player;

import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.Player;

public class ConsolePlayer
implements Player {
    private static final UUID consoleUUID = new UUID(0L, 0L);
    private static final String consoleUsername = "[CONSOLE]";
    private final HuskChat plugin;

    private ConsolePlayer(@NotNull HuskChat plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public String getName() {
        return consoleUsername;
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return consoleUUID;
    }

    @Override
    public int getPing() {
        return 0;
    }

    @Override
    @NotNull
    public String getServerName() {
        return this.plugin.getPlatform();
    }

    @Override
    public int getPlayersOnServer() {
        return this.plugin.getOnlinePlayers().size();
    }

    @Override
    public boolean hasPermission(String node) {
        return true;
    }

    @Override
    @NotNull
    public Audience getAudience() {
        return this.plugin.getConsole();
    }

    @NotNull
    public static ConsolePlayer create(@NotNull HuskChat plugin) {
        return new ConsolePlayer(plugin);
    }

    public static boolean isConsolePlayer(@NotNull UUID uuid) {
        return uuid.equals(consoleUUID);
    }

    public static boolean isConsolePlayer(@NotNull String username) {
        return username.equalsIgnoreCase(consoleUsername);
    }
}

