/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import net.kyori.adventure.audience.Audience;
import net.william278.huskchat.config.Locales;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.discord.DiscordHook;
import net.william278.huskchat.discord.SpicordHook;
import net.william278.huskchat.discord.WebHook;
import net.william278.huskchat.event.EventDispatcher;
import net.william278.huskchat.getter.DataGetter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.boostedyaml.YamlDocument;
import net.william278.huskchat.libraries.boostedyaml.dvs.versioning.BasicVersioning;
import net.william278.huskchat.libraries.boostedyaml.settings.dumper.DumperSettings;
import net.william278.huskchat.libraries.boostedyaml.settings.general.GeneralSettings;
import net.william278.huskchat.libraries.boostedyaml.settings.loader.LoaderSettings;
import net.william278.huskchat.libraries.boostedyaml.settings.updater.UpdaterSettings;
import net.william278.huskchat.libraries.desertwell.util.UpdateChecker;
import net.william278.huskchat.libraries.desertwell.util.Version;
import net.william278.huskchat.placeholders.PlaceholderReplacer;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;

public interface HuskChat {
    public static final int SPIGOT_RESOURCE_ID = 94496;

    @NotNull
    public Settings getSettings();

    public void setSettings(@NotNull Settings var1);

    @NotNull
    public Locales getLocales();

    public void setLocales(@NotNull Locales var1);

    default public void loadConfig() {
        try {
            this.setSettings(new Settings(YamlDocument.create(new File(this.getDataFolder(), "config.yml"), Objects.requireNonNull(this.getResource("config.yml")), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.builder().setEncoding(DumperSettings.Encoding.UNICODE).build(), UpdaterSettings.builder().setVersioning(new BasicVersioning("config-version")).build())));
            this.setLocales(new Locales(this));
            if (this.getSettings().doDiscordIntegration()) {
                this.setDiscordHook(this.getSettings().useSpicord() && this.isPluginPresent("Spicord") ? new SpicordHook(this) : new WebHook(this));
            }
        }
        catch (Throwable e) {
            this.log(Level.SEVERE, "Failed to load plugin config/locale files", e);
        }
    }

    @NotNull
    public EventDispatcher getEventDispatcher();

    @NotNull
    public PlayerCache getPlayerCache();

    @NotNull
    public List<PlaceholderReplacer> getPlaceholderReplacers();

    default public CompletableFuture<String> replacePlaceholders(@NotNull Player player, @NotNull String message) {
        CompletionStage<String> future = CompletableFuture.completedFuture(message);
        for (PlaceholderReplacer replacer : this.getPlaceholderReplacers()) {
            future = future.thenComposeAsync(toFormat -> replacer.formatPlaceholders((String)toFormat, player));
        }
        return future;
    }

    @NotNull
    public DataGetter getDataGetter();

    public Optional<DiscordHook> getDiscordHook();

    public void setDiscordHook(@NotNull DiscordHook var1);

    @NotNull
    public Version getVersion();

    @NotNull
    public String getPluginDescription();

    @NotNull
    public String getPlatform();

    public Optional<Player> getPlayer(@NotNull UUID var1);

    public Optional<Player> findPlayer(@NotNull String var1);

    public Collection<Player> getOnlinePlayers();

    public Collection<Player> getOnlinePlayersOnServer(@NotNull Player var1);

    @NotNull
    public Audience getConsole();

    public File getDataFolder();

    public InputStream getResource(@NotNull String var1);

    public boolean isPluginPresent(@NotNull String var1);

    @NotNull
    default public UpdateChecker getUpdateChecker() {
        return UpdateChecker.builder().currentVersion(this.getVersion()).endpoint(UpdateChecker.Endpoint.SPIGOT).resource(Integer.toString(94496)).build();
    }

    default public void checkForUpdates() {
        if (this.getSettings().doCheckForUpdates()) {
            this.getUpdateChecker().check().thenAccept(checked -> {
                if (!checked.isUpToDate()) {
                    this.log(Level.WARNING, "A new version of HuskChat is available: v" + checked.getLatestVersion() + " (running v" + this.getVersion() + ")", new Throwable[0]);
                }
            });
        }
    }

    public void log(@NotNull Level var1, @NotNull String var2, Throwable ... var3);
}

