/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.bungeecord;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bungeecord.BungeeAudiences;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.bungeecord.command.BungeeCommand;
import net.william278.huskchat.bungeecord.event.BungeeEventDispatcher;
import net.william278.huskchat.bungeecord.getter.BungeePermsDataGetter;
import net.william278.huskchat.bungeecord.listener.BungeeListener;
import net.william278.huskchat.bungeecord.player.BungeePlayer;
import net.william278.huskchat.command.ShortcutCommand;
import net.william278.huskchat.config.Locales;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.discord.DiscordHook;
import net.william278.huskchat.getter.DataGetter;
import net.william278.huskchat.getter.DefaultDataGetter;
import net.william278.huskchat.getter.LuckPermsDataGetter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.bstats.bungeecord.Metrics;
import net.william278.huskchat.libraries.desertwell.util.Version;
import net.william278.huskchat.placeholders.DefaultReplacer;
import net.william278.huskchat.placeholders.PAPIProxyBridgeReplacer;
import net.william278.huskchat.placeholders.PlaceholderReplacer;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;

public final class BungeeHuskChat
extends Plugin
implements HuskChat {
    private static final int METRICS_ID = 11882;
    private static BungeeHuskChat instance;
    private BungeeAudiences audiences;
    private Settings settings;
    private List<BungeeCommand> commands;
    private BungeeEventDispatcher eventDispatcher;
    private DiscordHook discordHook;
    private Locales locales;
    private DataGetter playerDataGetter;
    private PlayerCache playerCache;
    private List<PlaceholderReplacer> placeholders;

    public static BungeeHuskChat getInstance() {
        return instance;
    }

    public void onLoad() {
        instance = this;
        this.eventDispatcher = new BungeeEventDispatcher(this.getProxy());
        this.audiences = BungeeAudiences.create(this);
    }

    public void onEnable() {
        this.loadConfig();
        this.playerCache = new PlayerCache(this);
        this.playerDataGetter = this.isPluginPresent("LuckPerms") ? new LuckPermsDataGetter() : (this.isPluginPresent("BungeePerms") ? new BungeePermsDataGetter() : new DefaultDataGetter());
        this.placeholders = new ArrayList<PlaceholderReplacer>();
        this.placeholders.add(new DefaultReplacer(this));
        if (this.getSettings().doPlaceholderAPI() && this.isPluginPresent("PAPIProxyBridge")) {
            this.placeholders.add(new PAPIProxyBridgeReplacer(this));
        }
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new BungeeListener(this));
        this.commands = new ArrayList<BungeeCommand>(BungeeCommand.Type.getCommands(this));
        this.commands.addAll(this.getSettings().getChannels().values().stream().flatMap(channel -> channel.getShortcutCommands().stream().map(command -> new BungeeCommand(new ShortcutCommand((String)command, channel.getId(), (HuskChat)this), this))).toList());
        new Metrics(this, 11882);
        this.checkForUpdates();
        this.log(Level.INFO, "Enabled HuskChat version " + this.getVersion(), new Throwable[0]);
    }

    @Override
    @NotNull
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(@NotNull Settings settings) {
        this.settings = settings;
    }

    @Override
    @NotNull
    public Locales getLocales() {
        return this.locales;
    }

    @Override
    public void setLocales(@NotNull Locales locales) {
        this.locales = locales;
    }

    @Override
    @NotNull
    public Version getVersion() {
        return Version.fromString(this.getDescription().getVersion());
    }

    @Override
    @NotNull
    public String getPluginDescription() {
        return this.getDescription().getDescription();
    }

    @Override
    @NotNull
    public String getPlatform() {
        return ProxyServer.getInstance().getName();
    }

    @Override
    @NotNull
    public List<PlaceholderReplacer> getPlaceholderReplacers() {
        return this.placeholders;
    }

    @Override
    @NotNull
    public DataGetter getDataGetter() {
        return this.playerDataGetter;
    }

    @Override
    public Optional<DiscordHook> getDiscordHook() {
        return Optional.ofNullable(this.discordHook);
    }

    @Override
    public void setDiscordHook(@NotNull DiscordHook discordHook) {
        this.discordHook = discordHook;
    }

    @Override
    @NotNull
    public BungeeEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    @Override
    @NotNull
    public PlayerCache getPlayerCache() {
        return this.playerCache;
    }

    @Override
    public Optional<Player> getPlayer(@NotNull UUID uuid) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(uuid);
        if (player != null) {
            return Optional.of(BungeePlayer.adapt(player));
        }
        return Optional.empty();
    }

    @Override
    public Collection<Player> getOnlinePlayers() {
        ArrayList<Player> crossPlatform = new ArrayList<Player>();
        for (ProxiedPlayer player : ProxyServer.getInstance().getPlayers()) {
            crossPlatform.add(BungeePlayer.adapt(player));
        }
        return crossPlatform;
    }

    @Override
    public Collection<Player> getOnlinePlayersOnServer(@NotNull Player player) {
        ArrayList<Player> crossPlatform = new ArrayList<Player>();
        BungeePlayer.toBungee(player).ifPresent(bungeePlayer -> {
            for (ProxiedPlayer playerOnServer : bungeePlayer.getServer().getInfo().getPlayers()) {
                crossPlatform.add(BungeePlayer.adapt(playerOnServer));
            }
        });
        return crossPlatform;
    }

    @Override
    @NotNull
    public Audience getConsole() {
        return this.audiences.console();
    }

    @Override
    public InputStream getResource(@NotNull String path) {
        return this.getResourceAsStream(path);
    }

    @Override
    public boolean isPluginPresent(@NotNull String dependency) {
        return ProxyServer.getInstance().getPluginManager().getPlugin(dependency) != null;
    }

    @Override
    public void log(@NotNull Level level, @NotNull String message, Throwable ... exceptions) {
        if (exceptions.length > 0) {
            this.getLogger().log(level, message, exceptions[0]);
            return;
        }
        this.getLogger().log(level, message);
    }

    @NotNull
    public BungeeAudiences getAudience() {
        return this.audiences;
    }

    @Override
    public Optional<Player> findPlayer(@NotNull String username) {
        Optional<Player> optionalPlayer;
        if (username.isEmpty()) {
            return Optional.empty();
        }
        if (ProxyServer.getInstance().getPlayer(username) != null) {
            ProxiedPlayer player = ProxyServer.getInstance().getPlayer(username);
            optionalPlayer = Optional.of(BungeePlayer.adapt(player));
        } else {
            List<ProxiedPlayer> matchedPlayers = ProxyServer.getInstance().matchPlayer(username).stream().filter(val -> val.getName().startsWith(username)).sorted().toList();
            optionalPlayer = matchedPlayers.size() > 0 ? Optional.of(BungeePlayer.adapt(matchedPlayers.get(0))) : Optional.empty();
        }
        return optionalPlayer;
    }
}

