/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;

public class OptOutMessageCommand
extends CommandBase {
    public OptOutMessageCommand(@NotNull HuskChat plugin) {
        super(List.of("optoutmsg"), "", plugin);
    }

    @Override
    public void onExecute(@NotNull Player player, @NotNull String[] args) {
        PlayerCache.getLastMessengers(player.getUuid()).ifPresentOrElse(lastMessengers -> {
            if (lastMessengers.size() <= 1) {
                this.plugin.getLocales().sendMessage(player, "error_last_message_not_group", new String[0]);
                return;
            }
            for (UUID uuid : lastMessengers) {
                PlayerCache.getLastMessengers(uuid).ifPresent(last -> last.remove(player.getUuid()));
            }
            String playerList = lastMessengers.stream().flatMap(u -> this.plugin.getPlayer((UUID)u).stream()).map(Player::getName).collect(Collectors.joining(", "));
            StringBuilder builder = new StringBuilder();
            int lastComma = playerList.lastIndexOf(44);
            builder.append(playerList, 0, lastComma);
            builder.append(" ").append(this.plugin.getLocales().getRawLocale("list_conjunction"));
            builder.append(playerList.substring(lastComma + 1));
            this.plugin.getLocales().sendMessage(player, "removed_from_group_message", builder.toString());
            lastMessengers.clear();
        }, () -> this.plugin.getLocales().sendMessage(player, "error_no_messages_opt_out", new String[0]));
    }

    @Override
    public List<String> onTabComplete(@NotNull Player player, @NotNull String[] args) {
        return List.of();
    }
}

