/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.filter;

import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.libraries.profanitycheckerapi.ProfanityChecker;
import net.william278.huskchat.libraries.profanitycheckerapi.ProfanityCheckerBuilder;
import net.william278.huskchat.player.Player;

public class ProfanityFilterer
extends ChatFilter {
    @NotNull
    private final ProfanityCheckerBuilder builder = ProfanityChecker.builder();

    public ProfanityFilterer(@NotNull ProfanityFilterMode filterMode, double thresholdValue, @Nullable String libraryPath) {
        if (libraryPath != null && !libraryPath.isBlank()) {
            this.builder.withLibraryPath(libraryPath);
        }
        if (filterMode == ProfanityFilterMode.TOLERANCE) {
            this.builder.withThresholdChecking(thresholdValue);
        }
        this.initialize();
    }

    private void initialize() {
        try (ProfanityChecker ignored = this.builder.build();){
            System.out.println("Initialized the profanity checker and hooked into the jep interpreter");
        }
        catch (IllegalStateException | UnsatisfiedLinkError e) {
            throw new RuntimeException("Failed to initialize ProfanityChecker (" + e.getMessage() + ")Please ensure that the jep library is installed and the library path is correct. Consult the HuskChat docs for more information on this error.", e);
        }
    }

    @Override
    public boolean isAllowed(@NotNull Player player, @NotNull String message) {
        ProfanityChecker checker = this.builder.build();
        try {
            boolean bl;
            boolean bl2 = bl = !checker.isProfane(message);
            if (checker != null) {
                checker.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (checker != null) {
                    try {
                        checker.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    @Override
    @NotNull
    public String getFailureErrorMessageId() {
        return "error_chat_filter_profanity";
    }

    @Override
    @NotNull
    public String getFilterIgnorePermission() {
        return "huskchat.ignore_filters.profanity";
    }

    public static enum ProfanityFilterMode {
        AUTOMATIC,
        TOLERANCE;

    }
}

