/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.libraries.profanitycheckerapi;

import java.text.Normalizer;
import java.util.List;
import java.util.function.Function;
import net.william278.huskchat.libraries.annotations.NotNull;

public enum Normalizer {
    NFKD_NORMALIZER(text -> java.text.Normalizer.normalize(text, Normalizer.Form.NFKD).replaceAll("[^\\p{ASCII}]", "").toLowerCase().replaceAll("\\s{2,}", " ").trim()),
    LEET_CONVERTER(text -> text.replaceAll("1", "i").replaceAll("3", "e").replaceAll("4", "a").replaceAll("5", "s").replaceAll("7", "t").replaceAll("0", "o").replaceAll("9", "g").replaceAll("8", "b").replaceAll("6", "g"));

    @NotNull
    private final Function<String, String> normalize;

    private Normalizer(Function<String, String> normalizationFunction) {
        this.normalize = normalizationFunction;
    }

    @NotNull
    public String normalize(@NotNull String input) {
        return this.normalize.apply(input);
    }

    @NotNull
    public static List<Normalizer> all() {
        return List.of(Normalizer.values());
    }
}

