/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.getter;

import java.util.Optional;
import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.PermissionHolder;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.william278.huskchat.getter.DataGetter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.Player;

public class LuckPermsDataGetter
extends DataGetter {
    private final LuckPerms api = LuckPermsProvider.get();

    @Override
    public String getPlayerFullName(@NotNull Player player) {
        return this.getUser(player.getUuid()).map(PermissionHolder::getCachedData).map(data -> {
            StringBuilder fullName = new StringBuilder();
            String prefix = data.getMetaData().getPrefix();
            if (prefix != null) {
                fullName.append(prefix);
            }
            fullName.append(player.getName());
            String suffix = data.getMetaData().getSuffix();
            if (suffix != null) {
                fullName.append(suffix);
            }
            return fullName.toString();
        }).orElse(player.getName());
    }

    @Override
    public String getPlayerName(@NotNull Player player) {
        return player.getName();
    }

    @Override
    public Optional<String> getPlayerPrefix(@NotNull Player player) {
        return this.getUser(player.getUuid()).flatMap(user -> Optional.ofNullable(user.getCachedData().getMetaData().getPrefix()));
    }

    @Override
    public Optional<String> getPlayerSuffix(@NotNull Player player) {
        return this.getUser(player.getUuid()).flatMap(user -> Optional.ofNullable(user.getCachedData().getMetaData().getSuffix()));
    }

    @Override
    public Optional<String> getPlayerGroupName(@NotNull Player player) {
        return this.getUser(player.getUuid()).flatMap(user -> {
            Group group = this.api.getGroupManager().getGroup(user.getPrimaryGroup());
            if (group == null) {
                return Optional.empty();
            }
            return Optional.of(group.getName());
        });
    }

    @Override
    public Optional<String> getPlayerGroupDisplayName(@NotNull Player player) {
        return this.getUser(player.getUuid()).flatMap(user -> {
            Group group = this.api.getGroupManager().getGroup(user.getPrimaryGroup());
            if (group == null) {
                return Optional.empty();
            }
            if (group.getDisplayName() == null) {
                return Optional.of(group.getName());
            }
            return Optional.of(group.getDisplayName());
        });
    }

    private Optional<User> getUser(@NotNull UUID uuid) {
        return Optional.ofNullable(this.api.getUserManager().getUser(uuid));
    }
}

