/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.libraries.morepaperlib.morepaperlib.commands;

import java.lang.reflect.Field;
import java.util.Map;
import net.william278.huskchat.libraries.morepaperlib.morepaperlib.FeatureFailedException;
import net.william278.huskchat.libraries.morepaperlib.morepaperlib.MorePaperLib;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;

public final class CommandRegistration {
    private final MorePaperLib morePaperLib;
    private final boolean hasMethodGetCommandMap;
    private final boolean hasMethodGetKnownCommands;

    public CommandRegistration(MorePaperLib morePaperLib) {
        this.morePaperLib = morePaperLib;
        this.hasMethodGetCommandMap = morePaperLib.methodExists(Server.class, "getCommandMap", new Class[0]);
        this.hasMethodGetKnownCommands = morePaperLib.methodExists(SimpleCommandMap.class, "getKnownCommands", new Class[0]);
    }

    public CommandMap getServerCommandMap() {
        Server server = this.morePaperLib.getPlugin().getServer();
        if (this.hasMethodGetCommandMap) {
            return server.getCommandMap();
        }
        return this.getFieldValue(server.getClass(), server, "commandMap", CommandMap.class);
    }

    public Map<String, Command> getCommandMapKnownCommands(SimpleCommandMap simpleCommandMap) {
        if (this.hasMethodGetKnownCommands) {
            return simpleCommandMap.getKnownCommands();
        }
        Map knownCommands = this.getFieldValue(SimpleCommandMap.class, simpleCommandMap, "knownCommands", Map.class);
        return knownCommands;
    }

    <T, F> F getFieldValue(Class<? extends T> clazz, T object, String fieldName, Class<F> fieldType) {
        Object fieldValue;
        Field field;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException ex) {
            throw new FeatureFailedException("Unable to find field " + fieldName, ex);
        }
        try {
            field.setAccessible(true);
            fieldValue = field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            throw new FeatureFailedException("Unable to access field " + fieldName, ex);
        }
        if (!fieldType.isInstance(fieldValue)) {
            throw new FeatureFailedException("Field " + fieldName + " not an instance of " + fieldType.getName());
        }
        return fieldType.cast(fieldValue);
    }
}

