/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.bukkit.command;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.bukkit.BukkitHuskChat;
import net.william278.huskchat.bukkit.player.BukkitPlayer;
import net.william278.huskchat.command.BroadcastCommand;
import net.william278.huskchat.command.ChannelCommand;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.command.HuskChatCommand;
import net.william278.huskchat.command.MessageCommand;
import net.william278.huskchat.command.OptOutMessageCommand;
import net.william278.huskchat.command.ReplyCommand;
import net.william278.huskchat.command.SocialSpyCommand;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.ConsolePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitCommand
extends Command {
    private final BukkitHuskChat plugin;
    private final CommandBase command;

    public BukkitCommand(@NotNull CommandBase command, @NotNull BukkitHuskChat plugin) {
        super(command.getName(), command.getUsage(), command.getUsage(), command.getAliases());
        this.command = command;
        this.plugin = plugin;
        plugin.getCommandMap().register("huskchat", (Command)this);
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        CommandSender commandSender = sender;
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            this.command.onExecute(BukkitPlayer.adapt(player), args);
        } else {
            this.command.onExecute(ConsolePlayer.create(this.plugin), args);
        }
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
        Player player;
        CommandSender commandSender = sender;
        if (commandSender instanceof Player && (player = (Player)commandSender).hasPermission(this.command.getPermission())) {
            return this.command.onTabComplete(BukkitPlayer.adapt(player), args);
        }
        return List.of();
    }

    public static enum Type {
        HUSKCHAT(plugin -> Optional.of(new BukkitCommand(new HuskChatCommand((HuskChat)plugin), (BukkitHuskChat)plugin))),
        CHANNEL(plugin -> Optional.of(new BukkitCommand(new ChannelCommand((HuskChat)plugin), (BukkitHuskChat)plugin))),
        MESSAGE(plugin -> plugin.getSettings().isDoMessageCommand() ? Optional.of(new BukkitCommand(new MessageCommand((HuskChat)plugin), (BukkitHuskChat)plugin)) : Optional.empty()),
        REPLY(plugin -> plugin.getSettings().isDoMessageCommand() ? Optional.of(new BukkitCommand(new ReplyCommand((HuskChat)plugin), (BukkitHuskChat)plugin)) : Optional.empty()),
        OPT_OUT_MESSAGE(plugin -> plugin.getSettings().isDoMessageCommand() ? Optional.of(new BukkitCommand(new OptOutMessageCommand((HuskChat)plugin), (BukkitHuskChat)plugin)) : Optional.empty()),
        BROADCAST(plugin -> plugin.getSettings().isDoBroadcastCommand() ? Optional.of(new BukkitCommand(new BroadcastCommand((HuskChat)plugin), (BukkitHuskChat)plugin)) : Optional.empty()),
        SOCIAL_SPY(plugin -> plugin.getSettings().doSocialSpyCommand() ? Optional.of(new BukkitCommand(new SocialSpyCommand((HuskChat)plugin), (BukkitHuskChat)plugin)) : Optional.empty());

        private final Function<BukkitHuskChat, Optional<BukkitCommand>> commandSupplier;

        private Type(Function<BukkitHuskChat, Optional<BukkitCommand>> commandSupplier) {
            this.commandSupplier = commandSupplier;
        }

        @NotNull
        private Optional<BukkitCommand> create(@NotNull BukkitHuskChat plugin) {
            return this.commandSupplier.apply(plugin);
        }

        @NotNull
        public static List<BukkitCommand> getCommands(@NotNull BukkitHuskChat plugin) {
            return Arrays.stream(Type.values()).map(type -> type.create(plugin)).filter(Optional::isPresent).map(Optional::get).toList();
        }
    }
}

