/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.ConsolePlayer;
import net.william278.huskchat.player.Player;

public class ChannelCommand
extends CommandBase {
    public ChannelCommand(@NotNull HuskChat plugin) {
        super(plugin.getSettings().getChannelCommandAliases(), "<channel>", plugin);
    }

    @Override
    public void onExecute(@NotNull Player player, @NotNull String[] args) {
        if (player instanceof ConsolePlayer) {
            this.plugin.getLocales().sendMessage(player, "error_in_game_only", new String[0]);
            return;
        }
        if (player.hasPermission(this.getPermission())) {
            if (args.length == 1) {
                this.plugin.getPlayerCache().switchPlayerChannel(player, args[0]);
            } else {
                this.plugin.getLocales().sendMessage(player, "error_invalid_syntax", this.getUsage());
            }
        } else {
            this.plugin.getLocales().sendMessage(player, "error_no_permission", new String[0]);
        }
    }

    @Override
    public List<String> onTabComplete(@NotNull Player player, @NotNull String[] args) {
        if (!player.hasPermission(this.getPermission())) {
            return List.of();
        }
        if (args.length <= 1) {
            return this.getChannelIdsWithSendPermission(player).stream().filter(val -> val.toLowerCase().startsWith(args.length >= 1 ? args[0].toLowerCase() : "")).sorted().collect(Collectors.toList());
        }
        return List.of();
    }

    @NotNull
    public Set<String> getChannelIdsWithSendPermission(Player player) {
        HashSet<String> channelsWithPermission = new HashSet<String>();
        this.plugin.getSettings().getChannels().forEach((id, channel) -> {
            if (channel.getSendPermission() == null || player.hasPermission(channel.getSendPermission())) {
                channelsWithPermission.add(channel.getId());
            }
        });
        return channelsWithPermission;
    }
}

