/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.message;

import java.util.logging.Level;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.replacer.ReplacerFilter;

public class BroadcastMessage {
    private final Player sender;
    private String message;
    private final HuskChat plugin;

    public BroadcastMessage(@NotNull Player sender, @NotNull String message, @NotNull HuskChat plugin) {
        this.sender = sender;
        this.message = message;
        this.plugin = plugin;
    }

    public void dispatch() {
        this.plugin.getEventDispatcher().dispatchBroadcastMessageEvent(this.sender, this.message).thenAccept(event -> {
            if (event.isCancelled()) {
                return;
            }
            this.message = event.getMessage();
            if (!this.sender.hasPermission("huskchat.bypass_filters")) {
                for (ChatFilter filter : this.plugin.getSettings().getChatFilters().get("broadcast_messages")) {
                    if (this.sender.hasPermission(filter.getFilterIgnorePermission())) continue;
                    if (!filter.isAllowed(this.sender, this.message)) {
                        this.plugin.getLocales().sendMessage(this.sender, filter.getFailureErrorMessageId(), new String[0]);
                        return;
                    }
                    ChatFilter replacer$temp = filter;
                    if (!(replacer$temp instanceof ReplacerFilter)) continue;
                    ReplacerFilter replacer = (ReplacerFilter)replacer$temp;
                    this.message = replacer.replace(this.message);
                }
            }
            for (Player player : this.plugin.getOnlinePlayers()) {
                this.plugin.getLocales().sendFormattedBroadcastMessage(player, this.message);
            }
            if (this.plugin.getSettings().doLogBroadcasts()) {
                this.plugin.log(Level.INFO, this.plugin.getSettings().getBroadcastLogFormat() + this.message, new Throwable[0]);
            }
        });
    }
}

