/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.replacer;

import java.util.HashMap;
import java.util.Locale;
import java.util.StringJoiner;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.replacer.ReplacerFilter;

public class EmojiReplacer
extends ReplacerFilter {
    private final HashMap<String, String> emoticons;
    private final boolean caseInsensitive;

    public EmojiReplacer(HashMap<String, String> emoticons, boolean caseInsensitive) {
        this.emoticons = emoticons;
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    @NotNull
    public String replace(@NotNull String message) {
        String[] words = message.split(" ");
        StringJoiner replacedMessage = new StringJoiner(" ");
        for (String word : words) {
            for (String emoteFormat : this.emoticons.keySet()) {
                if (!this.caseInsensitive) {
                    if (!word.equals(emoteFormat)) continue;
                    word = this.emoticons.get(emoteFormat);
                    break;
                }
                if (!word.toLowerCase(Locale.ROOT).equals(emoteFormat)) continue;
                word = this.emoticons.get(emoteFormat);
                break;
            }
            replacedMessage.add(word);
        }
        return replacedMessage.toString();
    }

    @Override
    public boolean isAllowed(@NotNull Player sender, @NotNull String message) {
        return true;
    }

    @Override
    @NotNull
    public String getFailureErrorMessageId() {
        throw new UnsupportedOperationException("EmojiReplacer does not support failure messages");
    }

    @Override
    @NotNull
    public String getFilterIgnorePermission() {
        return "huskchat.ignore_filters.emoji_replacer";
    }
}

