/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import net.kyori.adventure.audience.Audience;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.ShortcutCommand;
import net.william278.huskchat.config.Locales;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.discord.DiscordHook;
import net.william278.huskchat.getter.DataGetter;
import net.william278.huskchat.getter.DefaultDataGetter;
import net.william278.huskchat.getter.LuckPermsDataGetter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.libraries.bstats.velocity.Metrics;
import net.william278.huskchat.libraries.desertwell.util.Version;
import net.william278.huskchat.placeholders.DefaultReplacer;
import net.william278.huskchat.placeholders.PAPIProxyBridgeReplacer;
import net.william278.huskchat.placeholders.PlaceholderReplacer;
import net.william278.huskchat.player.PlayerCache;
import net.william278.huskchat.velocity.command.VelocityCommand;
import net.william278.huskchat.velocity.event.VelocityEventDispatcher;
import net.william278.huskchat.velocity.listener.VelocityListener;
import net.william278.huskchat.velocity.player.VelocityPlayer;
import org.slf4j.Logger;

@Plugin(id="huskchat")
public class VelocityHuskChat
implements HuskChat {
    private static final int METRICS_ID = 14187;
    private static VelocityHuskChat instance;
    private final PluginContainer container;
    private final Logger logger;
    private final Metrics.Factory metrics;
    private final Path dataDirectory;
    private final ProxyServer server;
    private List<VelocityCommand> commands;
    private Settings settings;
    private VelocityEventDispatcher eventDispatcher;
    private DiscordHook discordHook;
    private Locales locales;
    private DataGetter playerDataGetter;
    private PlayerCache playerCache;
    private List<PlaceholderReplacer> placeholders;

    public static VelocityHuskChat getInstance() {
        return instance;
    }

    @Inject
    public VelocityHuskChat(@NotNull ProxyServer server, @NotNull Logger logger, @DataDirectory Path dataDirectory, @NotNull Metrics.Factory metrics, @NotNull PluginContainer pluginContainer) {
        instance = this;
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        this.metrics = metrics;
        this.container = pluginContainer;
    }

    @Subscribe
    public void onProxyInitialization(@NotNull ProxyInitializeEvent event) {
        this.loadConfig();
        this.eventDispatcher = new VelocityEventDispatcher(this.server);
        this.playerCache = new PlayerCache(this);
        this.playerDataGetter = this.isPluginPresent("luckperms") ? new LuckPermsDataGetter() : new DefaultDataGetter();
        this.placeholders = new ArrayList<PlaceholderReplacer>();
        this.placeholders.add(new DefaultReplacer(this));
        if (this.getSettings().doPlaceholderAPI() && this.isPluginPresent("papiproxybridge")) {
            this.placeholders.add(new PAPIProxyBridgeReplacer(this));
        }
        this.getProxyServer().getEventManager().register((Object)this, (Object)new VelocityListener(this));
        this.commands = new ArrayList<VelocityCommand>(VelocityCommand.Type.getCommands(this));
        this.commands.addAll(this.getSettings().getChannels().values().stream().flatMap(channel -> channel.getShortcutCommands().stream().map(command -> new VelocityCommand(new ShortcutCommand((String)command, channel.getId(), (HuskChat)this), this))).toList());
        this.metrics.make(this, 14187);
        this.checkForUpdates();
        this.log(Level.INFO, "Enabled HuskChat version " + this.getVersion(), new Throwable[0]);
    }

    @Override
    @NotNull
    public Locales getLocales() {
        return this.locales;
    }

    @Override
    public void setLocales(@NotNull Locales locales) {
        this.locales = locales;
    }

    @Override
    @NotNull
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(@NotNull Settings settings) {
        this.settings = settings;
    }

    @Override
    @NotNull
    public VelocityEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    @Override
    @NotNull
    public PlayerCache getPlayerCache() {
        return this.playerCache;
    }

    @Override
    public Optional<DiscordHook> getDiscordHook() {
        return Optional.ofNullable(this.discordHook);
    }

    @Override
    public void setDiscordHook(@NotNull DiscordHook discordHook) {
        this.discordHook = discordHook;
    }

    @Override
    @NotNull
    public Version getVersion() {
        return Version.fromString((String)this.container.getDescription().getVersion().orElseThrow(() -> new IllegalStateException("Could not fetch plugin version from container")));
    }

    @Override
    @NotNull
    public String getPluginDescription() {
        return this.container.getDescription().getDescription().orElse("Unknown");
    }

    @Override
    @NotNull
    public String getPlatform() {
        return "Velocity";
    }

    @Override
    @NotNull
    public List<PlaceholderReplacer> getPlaceholderReplacers() {
        return this.placeholders;
    }

    @Override
    @NotNull
    public DataGetter getDataGetter() {
        return this.playerDataGetter;
    }

    @Override
    public Optional<net.william278.huskchat.player.Player> getPlayer(@NotNull UUID uuid) {
        Optional player = this.getProxyServer().getPlayer(uuid);
        return player.map(VelocityPlayer::adapt);
    }

    @Override
    public Collection<net.william278.huskchat.player.Player> getOnlinePlayers() {
        ArrayList<net.william278.huskchat.player.Player> velocityPlayers = new ArrayList<net.william278.huskchat.player.Player>();
        for (Player player : this.getProxyServer().getAllPlayers()) {
            velocityPlayers.add(VelocityPlayer.adapt(player));
        }
        return velocityPlayers;
    }

    @Override
    public Collection<net.william278.huskchat.player.Player> getOnlinePlayersOnServer(@NotNull net.william278.huskchat.player.Player serverPlayer) {
        ArrayList<net.william278.huskchat.player.Player> velocityPlayers = new ArrayList<net.william278.huskchat.player.Player>();
        VelocityPlayer.toVelocity(serverPlayer).flatMap(Player::getCurrentServer).ifPresent(serverConnection -> {
            for (Player connectedPlayer : serverConnection.getServer().getPlayersConnected()) {
                velocityPlayers.add(VelocityPlayer.adapt(connectedPlayer));
            }
        });
        return velocityPlayers;
    }

    @Override
    @NotNull
    public Audience getConsole() {
        return this.getProxyServer().getConsoleCommandSource();
    }

    @Override
    public Optional<net.william278.huskchat.player.Player> findPlayer(@NotNull String username) {
        Optional<net.william278.huskchat.player.Player> optionalPlayer;
        if (username.isEmpty()) {
            return Optional.empty();
        }
        if (this.getProxyServer().getPlayer(username).isPresent()) {
            Player player = (Player)this.getProxyServer().getPlayer(username).get();
            optionalPlayer = Optional.of(VelocityPlayer.adapt(player));
        } else {
            List<Player> matchedPlayers = this.getProxyServer().matchPlayer(username).stream().filter(val -> val.getUsername().startsWith(username)).sorted().toList();
            optionalPlayer = matchedPlayers.size() > 0 ? Optional.of(VelocityPlayer.adapt(matchedPlayers.get(0))) : Optional.empty();
        }
        return optionalPlayer;
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return this.dataDirectory.toFile();
    }

    @Override
    @Nullable
    public InputStream getResource(@NotNull String path) {
        return HuskChat.class.getClassLoader().getResourceAsStream(path);
    }

    @Override
    public boolean isPluginPresent(@NotNull String dependency) {
        return this.getProxyServer().getPluginManager().getPlugin(dependency.toLowerCase(Locale.ENGLISH)).isPresent();
    }

    @NotNull
    public ProxyServer getProxyServer() {
        return this.server;
    }

    @Override
    public void log(@NotNull Level level, @NotNull String message, Throwable ... exceptions) {
        switch (level.getName()) {
            case "SEVERE": {
                if (exceptions.length > 0) {
                    this.logger.error(message, exceptions[0]);
                    break;
                }
                this.logger.error(message);
                break;
            }
            case "WARNING": {
                if (exceptions.length > 0) {
                    this.logger.warn(message, exceptions[0]);
                    break;
                }
                this.logger.warn(message);
                break;
            }
            default: {
                this.logger.info(message);
            }
        }
    }
}

