/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.bungeecord.event;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Event;
import net.william278.huskchat.bungeecord.event.BroadcastMessageEvent;
import net.william278.huskchat.bungeecord.event.ChatMessageEvent;
import net.william278.huskchat.bungeecord.event.PrivateMessageEvent;
import net.william278.huskchat.event.EventDispatcher;
import net.william278.huskchat.event.IBroadcastMessageEvent;
import net.william278.huskchat.event.IChatMessageEvent;
import net.william278.huskchat.event.IPrivateMessageEvent;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.Player;

public class BungeeEventDispatcher
implements EventDispatcher {
    private final ProxyServer server;

    public BungeeEventDispatcher(ProxyServer server) {
        this.server = server;
    }

    @Override
    public CompletableFuture<IChatMessageEvent> dispatchChatMessageEvent(@NotNull Player sender, @NotNull String message, @NotNull String channelId) {
        CompletableFuture<IChatMessageEvent> completableFuture = new CompletableFuture<IChatMessageEvent>();
        completableFuture.complete((IChatMessageEvent)this.server.getPluginManager().callEvent((Event)new ChatMessageEvent(sender, message, channelId)));
        return completableFuture;
    }

    @Override
    public CompletableFuture<IPrivateMessageEvent> dispatchPrivateMessageEvent(@NotNull Player sender, @NotNull List<Player> receivers, @NotNull String message) {
        CompletableFuture<IPrivateMessageEvent> completableFuture = new CompletableFuture<IPrivateMessageEvent>();
        completableFuture.complete((IPrivateMessageEvent)this.server.getPluginManager().callEvent((Event)new PrivateMessageEvent(sender, receivers, message)));
        return completableFuture;
    }

    @Override
    public CompletableFuture<IBroadcastMessageEvent> dispatchBroadcastMessageEvent(@NotNull Player sender, @NotNull String message) {
        CompletableFuture<IBroadcastMessageEvent> completableFuture = new CompletableFuture<IBroadcastMessageEvent>();
        completableFuture.complete((IBroadcastMessageEvent)this.server.getPluginManager().callEvent((Event)new BroadcastMessageEvent(sender, message)));
        return completableFuture;
    }
}

