/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.velocity.player;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.kyori.adventure.audience.Audience;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.velocity.VelocityHuskChat;

public class VelocityPlayer
implements net.william278.huskchat.player.Player {
    private static final VelocityHuskChat plugin = VelocityHuskChat.getInstance();
    private final Player player;

    private VelocityPlayer(Player player) {
        this.player = player;
    }

    @Override
    @NotNull
    public String getName() {
        return this.player.getUsername();
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.player.getUniqueId();
    }

    @Override
    public int getPing() {
        return (int)this.player.getPing();
    }

    @Override
    @NotNull
    public String getServerName() {
        AtomicReference connection = new AtomicReference();
        this.player.getCurrentServer().ifPresent(connection::set);
        if (connection.get() != null) {
            return ((ServerConnection)connection.get()).getServerInfo().getName();
        }
        return "";
    }

    @Override
    public int getPlayersOnServer() {
        AtomicReference connection = new AtomicReference();
        this.player.getCurrentServer().ifPresent(connection::set);
        if (connection.get() != null) {
            return ((ServerConnection)connection.get()).getServer().getPlayersConnected().size();
        }
        return 0;
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.player.hasPermission(permission);
    }

    @Override
    @NotNull
    public Audience getAudience() {
        return this.player;
    }

    public static Optional<Player> toVelocity(@NotNull net.william278.huskchat.player.Player player) {
        return plugin.getProxyServer().getPlayer(player.getUuid());
    }

    @NotNull
    public static VelocityPlayer adapt(Player player) {
        return new VelocityPlayer(player);
    }
}

