/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.bungeecord.command;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.TabExecutor;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.bungeecord.BungeeHuskChat;
import net.william278.huskchat.bungeecord.player.BungeePlayer;
import net.william278.huskchat.command.BroadcastCommand;
import net.william278.huskchat.command.ChannelCommand;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.command.HuskChatCommand;
import net.william278.huskchat.command.LocalSpyCommand;
import net.william278.huskchat.command.MessageCommand;
import net.william278.huskchat.command.OptOutMessageCommand;
import net.william278.huskchat.command.ReplyCommand;
import net.william278.huskchat.command.SocialSpyCommand;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.ConsolePlayer;

public class BungeeCommand
extends Command
implements TabExecutor {
    private final BungeeHuskChat plugin;
    private final CommandBase command;

    public BungeeCommand(@NotNull CommandBase command, @NotNull BungeeHuskChat plugin) {
        super(command.getName(), command.getPermission(), command.getAliases().toArray(new String[0]));
        this.command = command;
        this.plugin = plugin;
        plugin.getProxy().getPluginManager().registerCommand((Plugin)plugin, (Command)this);
    }

    public void execute(CommandSender sender, String[] args) {
        CommandSender commandSender = sender;
        if (commandSender instanceof ProxiedPlayer) {
            ProxiedPlayer player = (ProxiedPlayer)commandSender;
            this.command.onExecute(BungeePlayer.adapt(player), args);
        } else {
            this.command.onExecute(ConsolePlayer.create(this.plugin), args);
        }
    }

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        ProxiedPlayer player;
        CommandSender commandSender = sender;
        if (commandSender instanceof ProxiedPlayer && (player = (ProxiedPlayer)commandSender).hasPermission(this.command.getPermission())) {
            return this.command.onTabComplete(BungeePlayer.adapt(player), args);
        }
        return List.of();
    }

    public static enum Type {
        HUSKCHAT(plugin -> Optional.of(new BungeeCommand(new HuskChatCommand((HuskChat)plugin), (BungeeHuskChat)plugin))),
        CHANNEL(plugin -> Optional.of(new BungeeCommand(new ChannelCommand((HuskChat)plugin), (BungeeHuskChat)plugin))),
        MESSAGE(plugin -> plugin.getSettings().isDoMessageCommand() ? Optional.of(new BungeeCommand(new MessageCommand((HuskChat)plugin), (BungeeHuskChat)plugin)) : Optional.empty()),
        REPLY(plugin -> plugin.getSettings().isDoMessageCommand() ? Optional.of(new BungeeCommand(new ReplyCommand((HuskChat)plugin), (BungeeHuskChat)plugin)) : Optional.empty()),
        OPT_OUT_MESSAGE(plugin -> plugin.getSettings().isDoMessageCommand() ? Optional.of(new BungeeCommand(new OptOutMessageCommand((HuskChat)plugin), (BungeeHuskChat)plugin)) : Optional.empty()),
        BROADCAST(plugin -> plugin.getSettings().isDoBroadcastCommand() ? Optional.of(new BungeeCommand(new BroadcastCommand((HuskChat)plugin), (BungeeHuskChat)plugin)) : Optional.empty()),
        SOCIAL_SPY(plugin -> plugin.getSettings().doSocialSpyCommand() ? Optional.of(new BungeeCommand(new SocialSpyCommand((HuskChat)plugin), (BungeeHuskChat)plugin)) : Optional.empty()),
        LOCAL_SPY(plugin -> plugin.getSettings().doLocalSpyCommand() ? Optional.of(new BungeeCommand(new LocalSpyCommand((HuskChat)plugin), (BungeeHuskChat)plugin)) : Optional.empty());

        private final Function<BungeeHuskChat, Optional<BungeeCommand>> commandSupplier;

        private Type(Function<BungeeHuskChat, Optional<BungeeCommand>> commandSupplier) {
            this.commandSupplier = commandSupplier;
        }

        @NotNull
        private Optional<BungeeCommand> create(@NotNull BungeeHuskChat plugin) {
            return this.commandSupplier.apply(plugin);
        }

        @NotNull
        public static List<BungeeCommand> getCommands(@NotNull BungeeHuskChat plugin) {
            return Arrays.stream(Type.values()).map(type -> type.create(plugin)).filter(Optional::isPresent).map(Optional::get).toList();
        }
    }
}

