/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.config;

import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.libraries.boostedyaml.YamlDocument;
import net.william278.huskchat.libraries.minedown.adventure.MineDown;
import net.william278.huskchat.libraries.minedown.adventure.MineDownParser;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;

public class Locales {
    private final HuskChat plugin;
    private final Map<String, String> locales = new LinkedHashMap<String, String>();

    public Locales(@NotNull HuskChat plugin) {
        this.plugin = plugin;
        String languagePath = "locales/" + plugin.getSettings().getLanguage() + ".yml";
        try (InputStream stream = Objects.requireNonNull(plugin.getResource(languagePath));){
            YamlDocument document = YamlDocument.create(new File(plugin.getDataFolder(), "messages-" + plugin.getSettings().getLanguage() + ".yml"), stream);
            this.locales.clear();
            for (String messageId : document.getRoutesAsStrings(false)) {
                this.locales.put(messageId, document.getString(messageId, ""));
            }
        }
        catch (Throwable e) {
            plugin.log(Level.SEVERE, "Failed to load messages file", e);
        }
    }

    @Nullable
    public String getRawLocale(@NotNull String id) {
        return this.locales.get(id);
    }

    public void sendMessage(@NotNull Player player, @NotNull String id, String ... replacements) {
        String locale = this.getRawLocale(id);
        if (locale == null || locale.isEmpty()) {
            return;
        }
        int replacementIndexer = 1;
        for (String replacement : replacements) {
            String replacementString = "%" + replacementIndexer + "%";
            locale = locale.replace(replacementString, replacement);
            ++replacementIndexer;
        }
        player.sendMessage(new MineDown(locale));
    }

    public void sendChannelMessage(@NotNull Player target, @NotNull Player sender, @NotNull Channel channel, @NotNull String message) {
        this.plugin.replacePlaceholders(sender, channel.getFormat()).thenAccept(replaced -> {
            Component format = new MineDown((String)replaced).toComponent();
            TextComponent.Builder builder = (TextComponent.Builder)Component.text().append(format);
            if (sender.hasPermission("huskchat.formatted_chat")) {
                builder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent().color(this.getFormatColor(format)));
            } else {
                builder.append(Component.text(message).color(this.getFormatColor(format)));
            }
            target.sendMessage((Component)builder.build());
        });
    }

    public void sendOutboundPrivateMessage(@NotNull Player sender, @NotNull List<Player> recipients, @NotNull String message) {
        this.plugin.replacePlaceholders(recipients.get(0), recipients.size() == 1 ? this.plugin.getSettings().getOutboundMessageFormat() : this.plugin.getSettings().getGroupOutboundMessageFormat()).thenAccept(replaced -> {
            if (recipients.size() > 1) {
                replaced = replaced.replace("%group_amount_subscript%", this.superscriptNumber(recipients.size() - 1)).replace("%group_amount%", Integer.toString(recipients.size() - 1)).replace("%group_members_comma_separated%", this.getGroupMemberList(recipients, ",")).replace("%group_members%", MineDown.escape(this.getGroupMemberList(recipients, "\n")));
            }
            TextComponent.Builder builder = Component.text();
            Component format = new MineDown((String)replaced).toComponent();
            builder.append(format);
            if (sender.hasPermission("huskchat.formatted_chat")) {
                builder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent().color(this.getFormatColor(format)));
            } else {
                builder.append(Component.text(message).color(this.getFormatColor(format)));
            }
            sender.sendMessage((Component)builder.build());
        });
    }

    @Nullable
    private TextColor getFormatColor(@NotNull Component component) {
        TextColor color = component.color();
        if (component.children().isEmpty()) {
            return color;
        }
        for (Component child : component.children()) {
            TextColor childColor = this.getFormatColor(child);
            if (childColor == null) continue;
            color = childColor;
        }
        return color;
    }

    public void sendInboundPrivateMessage(List<Player> recipients, Player sender, String message) {
        this.plugin.replacePlaceholders(sender, recipients.size() == 1 ? this.plugin.getSettings().getInboundMessageFormat() : this.plugin.getSettings().getGroupInboundMessageFormat()).thenAccept(replaced -> {
            if (recipients.size() > 1) {
                replaced = replaced.replace("%group_amount_subscript%", this.superscriptNumber(recipients.size() - 1)).replace("%group_amount%", Integer.toString(recipients.size() - 1)).replace("%group_members_comma_separated%", this.getGroupMemberList(recipients, ",")).replace("%group_members%", MineDown.escape(this.getGroupMemberList(recipients, "\n")));
            }
            TextComponent.Builder builder = Component.text();
            Component format = new MineDown((String)replaced).toComponent();
            builder.append(format);
            if (sender.hasPermission("huskchat.formatted_chat")) {
                builder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent().color(this.getFormatColor(format)));
            } else {
                builder.append(Component.text(message).color(this.getFormatColor(format)));
            }
            for (Player recipient : recipients) {
                recipient.sendMessage((Component)builder.build());
            }
        });
    }

    public void sendLocalSpy(@NotNull Player spy, @NotNull PlayerCache.SpyColor spyColor, @NotNull Player sender, @NotNull Channel channel, @NotNull String message) {
        this.plugin.replacePlaceholders(sender, this.plugin.getSettings().getLocalSpyFormat()).thenAccept(replaced -> {
            TextComponent.Builder componentBuilder = (TextComponent.Builder)Component.text().append(new MineDown(replaced.replace("%spy_color%", spyColor.colorCode).replace("%channel%", channel.getId()) + MineDown.escape(message)).toComponent());
            spy.sendMessage((Component)componentBuilder.build());
        });
    }

    public void sendSocialSpy(@NotNull Player spy, @NotNull PlayerCache.SpyColor spyColor, @NotNull Player sender, @NotNull List<Player> receivers, @NotNull String message) {
        this.plugin.replacePlaceholders(sender, receivers.size() == 1 ? this.plugin.getSettings().getSocialSpyFormat() : this.plugin.getSettings().getSocialSpyGroupFormat().replace("%sender_", "%")).thenAccept(senderReplaced -> this.plugin.replacePlaceholders((Player)receivers.get(0), senderReplaced.replace("%receiver_", "%")).thenAccept(replaced -> {
            if (receivers.size() > 1) {
                replaced = replaced.replace("%group_amount_subscript%", this.superscriptNumber(receivers.size() - 1)).replace("%group_amount%", Integer.toString(receivers.size() - 1)).replace("%group_members_comma_separated%", this.getGroupMemberList(receivers, ",")).replace("%group_members%", MineDown.escape(this.getGroupMemberList(receivers, "\n")));
            }
            spy.sendMessage(new MineDown(replaced.replace("%spy_color%", spyColor.colorCode) + MineDown.escape(message)));
        }));
    }

    public void sendFormattedBroadcastMessage(@NotNull Player player, @NotNull String message) {
        TextComponent.Builder componentBuilder = Component.text();
        componentBuilder.append(new MineDown(this.plugin.getSettings().getBroadcastMessageFormat()).toComponent());
        componentBuilder.append(new MineDown(message).disable(MineDownParser.Option.ADVANCED_FORMATTING).toComponent());
        player.sendMessage((Component)componentBuilder.build());
    }

    @NotNull
    public final String getGroupMemberList(@NotNull List<Player> players, @NotNull String delimiter) {
        StringJoiner memberList = new StringJoiner(delimiter);
        for (Player player : players) {
            memberList.add(player.getName());
        }
        return memberList.toString();
    }

    @NotNull
    public final String superscriptNumber(int number) {
        String[] digits = new String[]{"\u2080", "\u2081", "\u2082", "\u2083", "\u2084", "\u2085", "\u2086", "\u2087", "\u2088", "\u2089"};
        StringBuilder sb = new StringBuilder();
        for (char c : String.valueOf(number).toCharArray()) {
            sb.append(digits[Integer.parseInt(String.valueOf(c))]);
        }
        return sb.toString();
    }
}

