/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.message;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.ConsolePlayer;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;
import net.william278.huskchat.replacer.ReplacerFilter;

public class ChatMessage {
    public final HuskChat plugin;
    public final String targetChannelId;
    public Player sender;
    public String message;

    public ChatMessage(@NotNull String targetChannelId, @NotNull Player sender, @NotNull String message, @NotNull HuskChat plugin) {
        this.targetChannelId = targetChannelId;
        this.sender = sender;
        this.message = message;
        this.plugin = plugin;
    }

    public boolean dispatch() {
        AtomicReference<Channel> channel = new AtomicReference<Channel>(this.plugin.getSettings().getChannels().get(this.targetChannelId));
        if (channel.get() == null) {
            this.plugin.getLocales().sendMessage(this.sender, "error_no_channel", new String[0]);
            return true;
        }
        if (channel.get().getSendPermission() != null && !this.sender.hasPermission(channel.get().getSendPermission())) {
            this.plugin.getLocales().sendMessage(this.sender, "error_no_permission_send", channel.get().getId());
            return true;
        }
        for (String restrictedServer : channel.get().getRestrictedServers()) {
            if (!restrictedServer.equalsIgnoreCase(this.sender.getServerName())) continue;
            this.plugin.getLocales().sendMessage(this.sender, "error_channel_restricted_server", channel.get().getId());
            return true;
        }
        Channel.BroadcastScope broadcastScope = channel.get().getBroadcastScope();
        if (this.sender instanceof ConsolePlayer && (broadcastScope == Channel.BroadcastScope.LOCAL || broadcastScope == Channel.BroadcastScope.LOCAL_PASSTHROUGH)) {
            this.plugin.getLocales().sendMessage(this.sender, "error_console_local_scope", new String[0]);
            return true;
        }
        StringBuilder msg = new StringBuilder(this.message);
        if (!ChatMessage.passesFilters(this.plugin, this.sender, msg, channel.get())) {
            return true;
        }
        this.message = msg.toString();
        HashSet<Player> messageRecipients = new HashSet<Player>();
        switch (broadcastScope) {
            case GLOBAL: 
            case GLOBAL_PASSTHROUGH: {
                messageRecipients.addAll(this.plugin.getOnlinePlayers());
                break;
            }
            case LOCAL: 
            case LOCAL_PASSTHROUGH: {
                messageRecipients.addAll(this.plugin.getOnlinePlayersOnServer(this.sender));
                break;
            }
        }
        this.plugin.getEventDispatcher().dispatchChatMessageEvent(this.sender, this.message, this.targetChannelId).thenAccept(event -> {
            if (event.isCancelled()) {
                return;
            }
            this.sender = event.getSender();
            if (!event.getChannelId().equals(((Channel)channel.get()).getId()) && this.plugin.getSettings().getChannels().containsKey(event.getChannelId())) {
                channel.set(this.plugin.getSettings().getChannels().get(event.getChannelId()));
            }
            this.message = event.getMessage();
            block2: for (Player recipient : messageRecipients) {
                if (((Channel)channel.get()).getReceivePermission() != null && !recipient.hasPermission(((Channel)channel.get()).getReceivePermission()) && !recipient.getUuid().equals(this.sender.getUuid())) continue;
                for (String restrictedServer : ((Channel)channel.get()).getRestrictedServers()) {
                    if (!restrictedServer.equalsIgnoreCase(recipient.getServerName())) continue;
                    continue block2;
                }
                this.plugin.getLocales().sendChannelMessage(recipient, this.sender, (Channel)channel.get(), this.message);
            }
            if ((broadcastScope == Channel.BroadcastScope.LOCAL || broadcastScope == Channel.BroadcastScope.LOCAL_PASSTHROUGH) && this.plugin.getSettings().doLocalSpyCommand() && !this.plugin.getSettings().isLocalSpyChannelExcluded((Channel)channel.get())) {
                Map<Player, PlayerCache.SpyColor> spies = this.plugin.getPlayerCache().getLocalSpyMessageReceivers(this.sender.getServerName(), this.plugin);
                for (Player spy : spies.keySet()) {
                    if (spy.getUuid().equals(this.sender.getUuid())) continue;
                    if (!spy.hasPermission("huskchat.command.localspy")) {
                        try {
                            this.plugin.getPlayerCache().removeLocalSpy(spy);
                        }
                        catch (IOException e) {
                            this.plugin.log(Level.SEVERE, "Failed to remove local spy after failed permission check", e);
                        }
                        continue;
                    }
                    PlayerCache.SpyColor color = spies.get(spy);
                    this.plugin.getLocales().sendLocalSpy(spy, color, this.sender, (Channel)channel.get(), this.message);
                }
            }
            if (((Channel)channel.get()).doLogMessages()) {
                String logFormat = this.plugin.getSettings().getChannelLogFormat().replaceAll("%channel%", ((Channel)channel.get()).getId().toUpperCase()).replaceAll("%sender%", this.sender.getName());
                this.plugin.log(Level.INFO, logFormat + this.message, new Throwable[0]);
            }
            if (this.plugin.getSettings().doDiscordIntegration()) {
                this.plugin.getWebhook().ifPresent(dispatcher -> dispatcher.dispatchWebhook(this));
            }
        });
        return !broadcastScope.isPassThrough;
    }

    public static boolean passesFilters(@NotNull HuskChat plugin, @NotNull Player sender, @NotNull StringBuilder message, @NotNull Channel channel) {
        if (channel.isFilter() && !sender.hasPermission("huskchat.bypass_filters")) {
            for (ChatFilter filter : plugin.getSettings().getChatFilters().getOrDefault(channel.getId(), List.of())) {
                if (sender.hasPermission(filter.getFilterIgnorePermission())) continue;
                if (!filter.isAllowed(sender, message.toString())) {
                    plugin.getLocales().sendMessage(sender, filter.getFailureErrorMessageId(), new String[0]);
                    return false;
                }
                ChatFilter chatFilter = filter;
                if (!(chatFilter instanceof ReplacerFilter)) continue;
                ReplacerFilter replacer = (ReplacerFilter)chatFilter;
                if (channel.getBroadcastScope().isPassThrough) continue;
                String msg = message.toString();
                message.delete(0, message.length());
                message.append(replacer.replace(msg));
            }
        }
        return true;
    }
}

