/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.bukkit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.bukkit.command.BukkitCommand;
import net.william278.huskchat.bukkit.event.BukkitEventDispatcher;
import net.william278.huskchat.bukkit.listener.BukkitListener;
import net.william278.huskchat.bukkit.placeholders.PlaceholderAPIReplacer;
import net.william278.huskchat.bukkit.player.BukkitPlayer;
import net.william278.huskchat.command.ShortcutCommand;
import net.william278.huskchat.config.Locales;
import net.william278.huskchat.config.Settings;
import net.william278.huskchat.discord.DiscordHook;
import net.william278.huskchat.event.EventDispatcher;
import net.william278.huskchat.getter.DataGetter;
import net.william278.huskchat.getter.DefaultDataGetter;
import net.william278.huskchat.getter.LuckPermsDataGetter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.desertwell.util.Version;
import net.william278.huskchat.libraries.morepaperlib.morepaperlib.MorePaperLib;
import net.william278.huskchat.placeholders.DefaultReplacer;
import net.william278.huskchat.placeholders.PlaceholderReplacer;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;
import org.bukkit.command.CommandMap;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitHuskChat
extends JavaPlugin
implements HuskChat {
    private static BukkitHuskChat instance;
    private MorePaperLib morePaperLib;
    private BukkitAudiences audiences;
    private Settings settings;
    private List<BukkitCommand> commands;
    private BukkitEventDispatcher eventDispatcher;
    private DiscordHook discordHook;
    private Locales locales;
    private DataGetter playerDataGetter;
    private PlayerCache playerCache;
    private List<PlaceholderReplacer> placeholders;

    public static BukkitHuskChat getInstance() {
        return instance;
    }

    public void onLoad() {
        instance = this;
    }

    public void onEnable() {
        this.audiences = BukkitAudiences.create((Plugin)this);
        this.morePaperLib = new MorePaperLib((Plugin)this);
        this.loadConfig();
        this.loadDiscordHook();
        this.playerCache = new PlayerCache(this);
        this.playerDataGetter = this.isPluginPresent("LuckPerms") ? new LuckPermsDataGetter() : new DefaultDataGetter();
        this.placeholders = new ArrayList<PlaceholderReplacer>();
        this.placeholders.add(new DefaultReplacer(this));
        if (this.getSettings().doPlaceholderAPI() && this.isPluginPresent("PlaceholderAPI")) {
            this.placeholders.add(new PlaceholderAPIReplacer());
        }
        this.eventDispatcher = new BukkitEventDispatcher(this);
        this.getServer().getPluginManager().registerEvents((Listener)new BukkitListener(this), (Plugin)this);
        this.commands = new ArrayList<BukkitCommand>(BukkitCommand.Type.getCommands(this));
        this.commands.addAll(this.getSettings().getChannels().values().stream().flatMap(channel -> channel.getShortcutCommands().stream().map(command -> new BukkitCommand(new ShortcutCommand((String)command, channel.getId(), (HuskChat)this), this))).toList());
        this.checkForUpdates();
        this.log(Level.INFO, "Enabled HuskChat version " + this.getVersion(), new Throwable[0]);
    }

    @Override
    @NotNull
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(@NotNull Settings settings) {
        this.settings = settings;
    }

    @Override
    @NotNull
    public Locales getLocales() {
        return this.locales;
    }

    @Override
    public void setLocales(@NotNull Locales locales) {
        this.locales = locales;
    }

    @Override
    @NotNull
    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    @Override
    @NotNull
    public PlayerCache getPlayerCache() {
        return this.playerCache;
    }

    @Override
    @NotNull
    public List<PlaceholderReplacer> getPlaceholderReplacers() {
        return this.placeholders;
    }

    @Override
    @NotNull
    public DataGetter getDataGetter() {
        return this.playerDataGetter;
    }

    @Override
    public Optional<DiscordHook> getDiscordHook() {
        return Optional.ofNullable(this.discordHook);
    }

    @Override
    public void setDiscordHook(@NotNull DiscordHook discordHook) {
        this.discordHook = discordHook;
    }

    @Override
    @NotNull
    public Version getVersion() {
        return Version.fromString(this.getDescription().getVersion());
    }

    @Override
    @NotNull
    public String getPluginDescription() {
        return Optional.ofNullable(this.getDescription().getDescription()).orElseThrow(() -> new IllegalStateException("Plugin description not found"));
    }

    @Override
    @NotNull
    public String getPlatform() {
        return this.getServer().getName();
    }

    @Override
    public Optional<Player> getPlayer(@NotNull UUID uuid) {
        return Optional.ofNullable(this.getServer().getPlayer(uuid)).map(BukkitPlayer::adapt);
    }

    @Override
    public Optional<Player> findPlayer(@NotNull String username) {
        return Optional.ofNullable(this.getServer().getPlayerExact(username)).map(BukkitPlayer::adapt);
    }

    @Override
    public Collection<Player> getOnlinePlayers() {
        return this.getServer().getOnlinePlayers().stream().map(user -> BukkitPlayer.adapt(user)).toList();
    }

    @Override
    public Collection<Player> getOnlinePlayersOnServer(@NotNull Player player) {
        return this.getOnlinePlayers();
    }

    @Override
    @NotNull
    public Audience getConsole() {
        return this.audiences.console();
    }

    @Override
    public boolean isPluginPresent(@NotNull String dependency) {
        return this.getServer().getPluginManager().getPlugin(dependency) != null;
    }

    @Override
    public void log(@NotNull Level level, @NotNull String message, Throwable ... exceptions) {
        if (exceptions.length > 0) {
            this.getLogger().log(level, message, exceptions[0]);
            return;
        }
        this.getLogger().log(level, message);
    }

    @NotNull
    public BukkitAudiences getAudience() {
        return this.audiences;
    }

    @NotNull
    public CommandMap getCommandMap() {
        return this.morePaperLib.commandRegistration().getServerCommandMap();
    }
}

