/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.bungeecord.player;

import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.william278.huskchat.bungeecord.BungeeHuskChat;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.Player;

public class BungeePlayer
implements Player {
    private final BungeeHuskChat plugin = BungeeHuskChat.getInstance();
    private final ProxiedPlayer player;

    private BungeePlayer(@NotNull ProxiedPlayer player) {
        this.player = player;
    }

    @Override
    @NotNull
    public String getName() {
        return this.player.getName();
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.player.getUniqueId();
    }

    @Override
    public int getPing() {
        return this.player.getPing();
    }

    @Override
    @NotNull
    public String getServerName() {
        return this.player.getServer().getInfo().getName();
    }

    @Override
    public int getPlayersOnServer() {
        return this.player.getServer().getInfo().getPlayers().size();
    }

    @Override
    public boolean hasPermission(String s) {
        return this.player.hasPermission(s);
    }

    @Override
    @NotNull
    public Audience getAudience() {
        return this.plugin.getAudience().player(this.player);
    }

    public static Optional<ProxiedPlayer> toBungee(@NotNull Player player) {
        ProxiedPlayer proxiedPlayer = ProxyServer.getInstance().getPlayer(player.getUuid());
        if (proxiedPlayer != null) {
            return Optional.of(proxiedPlayer);
        }
        return Optional.empty();
    }

    public static BungeePlayer adapt(@NotNull ProxiedPlayer player) {
        return new BungeePlayer(player);
    }
}

