/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.discord;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.discord.DiscordHook;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.message.ChatMessage;

public class WebHook
implements DiscordHook {
    private final HuskChat plugin;

    private Optional<URL> getWebhookUrl(@NotNull String channelId) {
        Map<String, URL> urls = this.plugin.getSettings().getWebhookUrls();
        if (urls.containsKey(channelId)) {
            return Optional.of(urls.get(channelId));
        }
        return Optional.empty();
    }

    public WebHook(@NotNull HuskChat plugin) {
        this.plugin = plugin;
    }

    @Override
    public void postMessage(@NotNull ChatMessage message) {
        CompletableFuture.runAsync(() -> this.getWebhookUrl(message.targetChannelId).ifPresent(webhookUrl -> {
            try {
                HttpURLConnection webhookConnection = (HttpURLConnection)webhookUrl.openConnection();
                webhookConnection.setRequestMethod("POST");
                webhookConnection.setDoOutput(true);
                byte[] jsonMessage = DiscordHook.getDiscordMessageJson(this.plugin, message);
                int messageLength = jsonMessage.length;
                webhookConnection.setFixedLengthStreamingMode(messageLength);
                webhookConnection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                webhookConnection.connect();
                try (OutputStream messageOutputStream = webhookConnection.getOutputStream();){
                    messageOutputStream.write(jsonMessage);
                }
            }
            catch (Throwable e) {
                this.plugin.log(Level.WARNING, "Unable to send message to Discord webhook", e);
            }
        }));
    }
}

