/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.libraries.simpleast.core.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.william278.huskchat.libraries.simpleast.core.TextStyle;
import net.william278.huskchat.libraries.simpleast.core.node.Node;
import net.william278.huskchat.libraries.simpleast.core.node.StyleNode;
import net.william278.huskchat.libraries.simpleast.core.node.TextNode;
import net.william278.huskchat.libraries.simpleast.core.parser.ParseSpec;
import net.william278.huskchat.libraries.simpleast.core.parser.Parser;
import net.william278.huskchat.libraries.simpleast.core.parser.Rule;

public class SimpleMarkdownRules {
    private static final Pattern PATTERN_BOLD = Pattern.compile("^\\*\\*([\\s\\S]+?)\\*\\*(?!\\*)");
    private static final Pattern PATTERN_UNDERLINE = Pattern.compile("^__([\\s\\S]+?)__(?!_)");
    private static final Pattern PATTERN_STRIKETHRU = Pattern.compile("^~~(?=\\S)([\\s\\S]*?\\S)~~");
    private static final Pattern PATTERN_NEWLINE = Pattern.compile("^(?:\\n *)*\\n");
    private static final Pattern PATTERN_LINK = Pattern.compile("^(https?://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]+\\.[-a-zA-Z0-9+&@#/%=~_|]+)");
    private static final Pattern PATTERN_TEXT = Pattern.compile("^[\\s\\S]+?(?=[^0-9A-Za-z\\s\\u00c0-\\uffff]|\\n| {2,}\\n|\\w+:\\S|$)");
    private static final Pattern PATTERN_ESCAPE = Pattern.compile("^\\\\([^0-9A-Za-z\\s])");
    private static final Pattern PATTERN_ITALICS = Pattern.compile("^\\b_((?:__|\\\\[\\s\\S]|[^\\\\_])+?)_\\b|^\\*(?=\\S)((?:\\*\\*|\\s+(?:[^*\\s]|\\*\\*)|[^\\s*])+?)\\*(?!\\*)");

    public static <R, S> Rule<R, Node<R>, S> createLinkRule() {
        return new Rule<R, Node<R>, S>(PATTERN_LINK){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                String link = matcher.group(1);
                HashMap<String, String> extra = new HashMap<String, String>();
                extra.put("link", link);
                return ParseSpec.createTerminal(StyleNode.Companion.createWithText(link, Collections.singletonList(new TextStyle(TextStyle.Type.LINK, extra))), state);
            }
        };
    }

    public static <R, S> Rule<R, Node<R>, S> createBoldRule() {
        return SimpleMarkdownRules.createSimpleStyleRule(PATTERN_BOLD, new TextStyle(TextStyle.Type.BOLD));
    }

    public static <R, S> Rule<R, Node<R>, S> createUnderlineRule() {
        return SimpleMarkdownRules.createSimpleStyleRule(PATTERN_UNDERLINE, new TextStyle(TextStyle.Type.UNDERLINE));
    }

    public static <R, S> Rule<R, Node<R>, S> createStrikethruRule() {
        return SimpleMarkdownRules.createSimpleStyleRule(PATTERN_STRIKETHRU, new TextStyle(TextStyle.Type.STRIKETHROUGH));
    }

    public static <R, S> Rule<R, Node<R>, S> createTextRule() {
        return new Rule<R, Node<R>, S>(PATTERN_TEXT){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                return ParseSpec.createTerminal(new TextNode(matcher.group()), state);
            }
        };
    }

    public static <R, S> Rule<R, Node<R>, S> createNewlineRule() {
        return new Rule<R, Node<R>, S>(PATTERN_NEWLINE){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                return ParseSpec.createTerminal(new TextNode("\n"), state);
            }
        };
    }

    public static <R, S> Rule<R, Node<R>, S> createEscapeRule() {
        return new Rule<R, Node<R>, S>(PATTERN_ESCAPE){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                return ParseSpec.createTerminal(new TextNode(matcher.group(1)), state);
            }
        };
    }

    public static <R, S> Rule<R, Node<R>, S> createItalicsRule() {
        return new Rule<R, Node<R>, S>(PATTERN_ITALICS){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                int endIndex;
                int startIndex;
                boolean asterisk;
                String asteriskMatch = matcher.group(2);
                boolean bl = asterisk = asteriskMatch != null && asteriskMatch.length() > 0;
                if (asterisk) {
                    startIndex = matcher.start(2);
                    endIndex = matcher.end(2);
                } else {
                    startIndex = matcher.start(1);
                    endIndex = matcher.end(1);
                }
                HashMap<String, String> extra = new HashMap<String, String>();
                extra.put("asterisk", String.valueOf(asterisk));
                ArrayList<TextStyle> styles = new ArrayList<TextStyle>(Collections.singletonList(new TextStyle(TextStyle.Type.ITALICS, extra)));
                return ParseSpec.createNonterminal(new StyleNode(styles), state, startIndex, endIndex);
            }
        };
    }

    public static <R, S> Rule<R, Node<R>, S> createSimpleStyleRule(Pattern pattern, final TextStyle textStyle) {
        return new Rule<R, Node<R>, S>(pattern){

            @Override
            public ParseSpec<R, Node<R>, S> parse(Matcher matcher, Parser<R, Node<R>, S> parser, S state) {
                return ParseSpec.createNonterminal(new StyleNode(new ArrayList<TextStyle>(Collections.singletonList(textStyle))), state, matcher.start(1), matcher.end(1));
            }
        };
    }

    public static <R, S> List<Rule<R, Node<R>, S>> createSimpleMarkdownRules(boolean includeTextRule) {
        ArrayList<Rule<R, Node<R>, S>> rules = new ArrayList<Rule<R, Node<R>, S>>();
        rules.add(SimpleMarkdownRules.createEscapeRule());
        rules.add(SimpleMarkdownRules.createLinkRule());
        rules.add(SimpleMarkdownRules.createNewlineRule());
        rules.add(SimpleMarkdownRules.createBoldRule());
        rules.add(SimpleMarkdownRules.createUnderlineRule());
        rules.add(SimpleMarkdownRules.createItalicsRule());
        rules.add(SimpleMarkdownRules.createStrikethruRule());
        if (includeTextRule) {
            rules.add(SimpleMarkdownRules.createTextRule());
        }
        return rules;
    }
}

