/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.velocity.command;

import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.BroadcastCommand;
import net.william278.huskchat.command.ChannelCommand;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.command.HuskChatCommand;
import net.william278.huskchat.command.LocalSpyCommand;
import net.william278.huskchat.command.MessageCommand;
import net.william278.huskchat.command.OptOutMessageCommand;
import net.william278.huskchat.command.ReplyCommand;
import net.william278.huskchat.command.SocialSpyCommand;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.ConsolePlayer;
import net.william278.huskchat.velocity.VelocityHuskChat;
import net.william278.huskchat.velocity.player.VelocityPlayer;

public class VelocityCommand
implements SimpleCommand {
    private final VelocityHuskChat plugin;
    private final CommandBase command;

    public VelocityCommand(@NotNull CommandBase command, @NotNull VelocityHuskChat plugin) {
        this.command = command;
        this.plugin = plugin;
        plugin.getProxyServer().getCommandManager().register(command.getName(), (Command)this, command.getAliases().toArray(new String[0]));
    }

    public void execute(@NotNull SimpleCommand.Invocation invocation) {
        CommandSource commandSource = invocation.source();
        if (commandSource instanceof Player) {
            Player player = (Player)commandSource;
            this.command.onExecute(VelocityPlayer.adapt(player), (String[])invocation.arguments());
        } else {
            this.command.onExecute(ConsolePlayer.create(this.plugin), (String[])invocation.arguments());
        }
    }

    public List<String> suggest(@NotNull SimpleCommand.Invocation invocation) {
        CommandSource commandSource = invocation.source();
        if (commandSource instanceof Player) {
            Player player = (Player)commandSource;
            return this.command.onTabComplete(VelocityPlayer.adapt(player), (String[])invocation.arguments());
        }
        return List.of();
    }

    public boolean hasPermission(@NotNull SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission(this.command.getPermission());
    }

    public static enum Type {
        HUSKCHAT(plugin -> Optional.of(new VelocityCommand(new HuskChatCommand((HuskChat)plugin), (VelocityHuskChat)plugin))),
        CHANNEL(plugin -> Optional.of(new VelocityCommand(new ChannelCommand((HuskChat)plugin), (VelocityHuskChat)plugin))),
        MESSAGE(plugin -> plugin.getSettings().isDoMessageCommand() ? Optional.of(new VelocityCommand(new MessageCommand((HuskChat)plugin), (VelocityHuskChat)plugin)) : Optional.empty()),
        REPLY(plugin -> plugin.getSettings().isDoMessageCommand() ? Optional.of(new VelocityCommand(new ReplyCommand((HuskChat)plugin), (VelocityHuskChat)plugin)) : Optional.empty()),
        OPT_OUT_MESSAGE(plugin -> plugin.getSettings().isDoMessageCommand() ? Optional.of(new VelocityCommand(new OptOutMessageCommand((HuskChat)plugin), (VelocityHuskChat)plugin)) : Optional.empty()),
        BROADCAST(plugin -> plugin.getSettings().isDoBroadcastCommand() ? Optional.of(new VelocityCommand(new BroadcastCommand((HuskChat)plugin), (VelocityHuskChat)plugin)) : Optional.empty()),
        SOCIAL_SPY(plugin -> plugin.getSettings().doSocialSpyCommand() ? Optional.of(new VelocityCommand(new SocialSpyCommand((HuskChat)plugin), (VelocityHuskChat)plugin)) : Optional.empty()),
        LOCAL_SPY(plugin -> plugin.getSettings().doLocalSpyCommand() ? Optional.of(new VelocityCommand(new LocalSpyCommand((HuskChat)plugin), (VelocityHuskChat)plugin)) : Optional.empty());

        private final Function<VelocityHuskChat, Optional<VelocityCommand>> commandSupplier;

        private Type(Function<VelocityHuskChat, Optional<VelocityCommand>> commandSupplier) {
            this.commandSupplier = commandSupplier;
        }

        @NotNull
        private Optional<VelocityCommand> create(@NotNull VelocityHuskChat plugin) {
            return this.commandSupplier.apply(plugin);
        }

        public static List<VelocityCommand> getCommands(@NotNull VelocityHuskChat plugin) {
            return Arrays.stream(Type.values()).map(type -> type.create(plugin)).filter(Optional::isPresent).map(Optional::get).toList();
        }
    }
}

