/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.bukkit.listener;

import net.william278.huskchat.HuskChat;
import net.william278.huskchat.bukkit.player.BukkitPlayer;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.listener.PlayerListener;
import net.william278.huskchat.message.ChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class BukkitListener
extends PlayerListener
implements Listener {
    public BukkitListener(@NotNull HuskChat plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent e) {
        Player player = e.getPlayer();
        boolean shouldCancel = new ChatMessage(this.plugin.getPlayerCache().getPlayerChannel(player.getUniqueId()), BukkitPlayer.adapt(player), e.getMessage(), this.plugin).dispatch();
        if (shouldCancel) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent e) {
        BukkitPlayer player = BukkitPlayer.adapt(e.getPlayer());
        super.handlePlayerSwitchServer(player, player.getServerName());
        if (this.plugin.getSettings().doJoinMessages() || !this.plugin.getSettings().getJoinQuitBroadcastScope().isPassThrough) {
            e.setJoinMessage(null);
        }
        super.handlePlayerJoin(player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        if (this.plugin.getSettings().doQuitMessages() || !this.plugin.getSettings().getJoinQuitBroadcastScope().isPassThrough) {
            e.setQuitMessage(null);
        }
        super.handlePlayerQuit(BukkitPlayer.adapt(e.getPlayer()));
    }
}

