/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.List;
import java.util.Locale;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.Player;

public abstract class CommandBase {
    protected final List<String> aliases;
    protected final String usage;
    protected final HuskChat plugin;

    public CommandBase(@NotNull List<String> aliases, @NotNull String usage, @NotNull HuskChat plugin) {
        if (aliases.isEmpty()) {
            throw new IllegalArgumentException("Command must have at least one alias");
        }
        this.aliases = aliases.stream().map(s -> s.toLowerCase(Locale.ENGLISH)).toList();
        this.usage = usage;
        this.plugin = plugin;
    }

    public abstract void onExecute(@NotNull Player var1, @NotNull String[] var2);

    public abstract List<String> onTabComplete(@NotNull Player var1, @NotNull String[] var2);

    @NotNull
    public String getName() {
        return this.aliases.get(0);
    }

    @NotNull
    public List<String> getAliases() {
        return this.aliases.subList(1, this.aliases.size());
    }

    @NotNull
    public String getUsage() {
        return "/" + this.getName() + " " + this.usage;
    }

    @NotNull
    public String getPermission() {
        return "huskchat.command." + this.getName();
    }
}

