/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.desertwell.about.AboutMenu;
import net.william278.huskchat.libraries.desertwell.util.UpdateChecker;
import net.william278.huskchat.libraries.minedown.adventure.MineDown;
import net.william278.huskchat.player.Player;

public class HuskChatCommand
extends CommandBase {
    private static final String[] COMMAND_TAB_ARGUMENTS = new String[]{"about", "reload", "update"};
    private final UpdateChecker updateChecker;
    private final AboutMenu aboutMenu;

    public HuskChatCommand(@NotNull HuskChat plugin) {
        super(List.of("huskchat"), "[about|reload|update]", plugin);
        this.updateChecker = plugin.getUpdateChecker();
        this.aboutMenu = AboutMenu.builder().title(Component.text("HuskChat")).description(Component.text(plugin.getPluginDescription())).version(plugin.getVersion()).credits("Author", AboutMenu.Credit.of("William278").description("Click to visit website").url("https://william278.net")).credits("Contributors", AboutMenu.Credit.of("TrueWinter").description("Code"), AboutMenu.Credit.of("Ironboundred").description("Code")).credits("Translators", AboutMenu.Credit.of("xF3d3").description("Italian (it-it)"), AboutMenu.Credit.of("MalzSmith").description("Hungarian (hu-hu)"), AboutMenu.Credit.of("Ceddix").description("German (de-de)"), AboutMenu.Credit.of("Pukejoy_1").description("Bulgarian (bg-bg)"), AboutMenu.Credit.of("XeroLe1er").description("French (fr-fr)")).buttons(AboutMenu.Link.of("https://william278.net/docs/huskchat").text("Documentation").icon("\u26cf"), AboutMenu.Link.of("https://github.com/WiIIiam278/HuskChat/issues").text("Issues").icon("\u274c").color(TextColor.color(0xFF9F0F)), AboutMenu.Link.of("https://discord.gg/tVYhJfyDWG").text("Discord").icon("\u2b50").color(TextColor.color(6779893))).build();
    }

    @Override
    public void onExecute(@NotNull Player player, @NotNull String[] args) {
        if (!player.hasPermission(this.getPermission())) {
            this.plugin.getLocales().sendMessage(player, "error_no_permission", new String[0]);
            return;
        }
        if (args.length >= 1) {
            switch (args[0].toLowerCase(Locale.ROOT)) {
                case "about": 
                case "info": {
                    player.sendMessage(this.aboutMenu.toComponent());
                    break;
                }
                case "update": {
                    this.updateChecker.check().thenAccept(checked -> {
                        if (checked.isUpToDate()) {
                            this.plugin.getLocales().sendMessage(player, "up_to_date", this.plugin.getVersion().toString());
                            return;
                        }
                        this.plugin.getLocales().sendMessage(player, "update_available", checked.getLatestVersion().toString(), this.plugin.getVersion().toString());
                    });
                    break;
                }
                case "reload": {
                    this.plugin.loadConfig();
                    player.sendMessage(new MineDown("[HuskChat](#00fb9a bold) &#00fb9a&| Reloaded config & message files."));
                    break;
                }
                default: {
                    this.plugin.getLocales().sendMessage(player, "error_invalid_syntax", this.getUsage());
                }
            }
            return;
        }
        player.sendMessage(this.aboutMenu.toComponent());
    }

    @Override
    public List<String> onTabComplete(@NotNull Player player, @NotNull String[] args) {
        if (!player.hasPermission(this.getPermission())) {
            return List.of();
        }
        if (args.length <= 1) {
            return Arrays.stream(COMMAND_TAB_ARGUMENTS).filter(i -> i.toLowerCase().startsWith(args.length == 1 ? args[0].toLowerCase() : "")).sorted().toList();
        }
        return List.of();
    }
}

