/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.ConsolePlayer;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;

public class SocialSpyCommand
extends CommandBase {
    public SocialSpyCommand(@NotNull HuskChat plugin) {
        super(plugin.getSettings().getSocialSpyCommandAliases(), "[color]", plugin);
    }

    @Override
    public void onExecute(@NotNull Player player, @NotNull String[] args) {
        if (player instanceof ConsolePlayer) {
            this.plugin.getLocales().sendMessage(player, "error_in_game_only", new String[0]);
            return;
        }
        if (player.hasPermission(this.getPermission())) {
            Optional<PlayerCache.SpyColor> selectedColor;
            if (args.length == 1 && (selectedColor = PlayerCache.SpyColor.getColor(args[0])).isPresent()) {
                try {
                    PlayerCache.SpyColor color = selectedColor.get();
                    this.plugin.getPlayerCache().setSocialSpy(player, color);
                    this.plugin.getLocales().sendMessage(player, "social_spy_toggled_on_color", color.colorCode, color.name().toLowerCase().replaceAll("_", " "));
                }
                catch (IOException e) {
                    this.plugin.log(Level.SEVERE, "Failed to save social spy state to spies file", new Throwable[0]);
                }
                return;
            }
            if (!this.plugin.getPlayerCache().isSocialSpying(player)) {
                try {
                    this.plugin.getPlayerCache().setSocialSpy(player);
                    this.plugin.getLocales().sendMessage(player, "social_spy_toggled_on", new String[0]);
                }
                catch (IOException e) {
                    this.plugin.log(Level.SEVERE, "Failed to save social spy state to spies file", new Throwable[0]);
                }
            } else {
                try {
                    this.plugin.getPlayerCache().removeSocialSpy(player);
                    this.plugin.getLocales().sendMessage(player, "social_spy_toggled_off", new String[0]);
                }
                catch (IOException e) {
                    this.plugin.log(Level.SEVERE, "Failed to save social spy state to spies file", new Throwable[0]);
                }
            }
        } else {
            this.plugin.getLocales().sendMessage(player, "error_no_permission", new String[0]);
        }
    }

    @Override
    public List<String> onTabComplete(@NotNull Player player, @NotNull String[] args) {
        return List.of();
    }
}

