/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.discord;

import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.discord.DiscordHook;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.mcdiscordreserializer.discord.DiscordSerializer;
import net.william278.huskchat.message.ChatMessage;
import net.william278.huskchat.player.Player;
import org.spicord.Spicord;
import org.spicord.api.addon.SimpleAddon;
import org.spicord.bot.DiscordBot;

public class SpicordHook
implements DiscordHook {
    private final Addon addon;

    public SpicordHook(@NotNull HuskChat plugin) {
        this.addon = new Addon(plugin);
        if (Spicord.getInstance().getAddonManager().registerAddon((SimpleAddon)this.addon)) {
            plugin.log(Level.INFO, "Registered HuskChat Spicord addon", new Throwable[0]);
        } else {
            plugin.log(Level.SEVERE, "Unable to register HuskChat Spicord addon", new Throwable[0]);
        }
    }

    @Override
    public void postMessage(@NotNull ChatMessage message) {
        if (message.sender instanceof SpicordPlayer) {
            return;
        }
        CompletableFuture.runAsync(() -> this.addon.sendMessage(message));
    }

    private static class Addon
    extends SimpleAddon {
        private final HuskChat plugin;
        private DiscordBot bot;

        private Addon(@NotNull HuskChat plugin) {
            super("HuskChat", "huskchat", "William278", plugin.getVersion().toString());
            this.plugin = plugin;
        }

        private void sendMessage(@NotNull ChatMessage message) {
            Optional discordChannelId = Optional.ofNullable(this.plugin.getSettings().getSpicordReceiveChannelMap().get(message.targetChannelId)).flatMap(id -> {
                try {
                    return Optional.of(Long.parseLong(id.trim()));
                }
                catch (NumberFormatException e) {
                    this.plugin.log(Level.WARNING, "Invalid Discord channel ID found in Spicord channel send map", new Throwable[0]);
                    return Optional.empty();
                }
            });
            if (discordChannelId.isEmpty()) {
                return;
            }
            if (this.bot == null || this.bot.getJda() == null) {
                this.plugin.log(Level.WARNING, "No active bots found to dispatch message! Have you added \"huskchat\" to the \"addons:\" section of a bot in your Spicord config?", new Throwable[0]);
                return;
            }
            JDA jda = this.bot.getJda();
            GuildChannel channel = jda.getGuildChannelById(((Long)discordChannelId.get()).longValue());
            GuildChannel guildChannel = channel;
            if (!(guildChannel instanceof GuildMessageChannel)) {
                this.plugin.log(Level.WARNING, "Unable to find Discord channel with ID " + discordChannelId.get(), new Throwable[0]);
                return;
            }
            GuildMessageChannel guildChannel2 = (GuildMessageChannel)guildChannel;
            if (!guildChannel2.canTalk()) {
                this.plugin.log(Level.WARNING, "Unable to send message to Discord channel with ID " + discordChannelId.get() + " (no permission)", new Throwable[0]);
                return;
            }
            this.dispatchMessage(message, guildChannel2);
        }

        private void dispatchMessage(@NotNull ChatMessage message, @NotNull GuildMessageChannel channel) {
            DiscordHook.Format format = this.plugin.getSettings().getDiscordMessageFormat();
            channel.sendMessage(((MessageCreateBuilder)((MessageCreateBuilder)((MessageCreateBuilder)new MessageCreateBuilder().setAllowedMentions(List.of())).setEmbeds(format == DiscordHook.Format.EMBEDDED ? List.of(new EmbedBuilder().setDescription((CharSequence)message.message).setColor(64410).setFooter(String.format("%s \u2022 %s", message.sender.getName(), message.sender.getServerName()), String.format("https://crafatar.com/avatars/%s?size=64", message.sender.getUuid())).setTimestamp((TemporalAccessor)OffsetDateTime.now()).build()) : List.of())).setContent(format == DiscordHook.Format.INLINE ? String.format("### %s\n%s", message.sender.getName(), message.message) : null)).build()).queue();
        }

        public void onLoad(DiscordBot bot) {
            this.bot = bot;
            this.plugin.log(Level.INFO, "Loaded HuskChat Spicord addon", new Throwable[0]);
        }

        public void onMessageReceived(@NotNull DiscordBot bot, @NotNull MessageReceivedEvent event) {
            if (event.getAuthor().isBot()) {
                return;
            }
            Optional<String> serverChannelId = Optional.ofNullable(this.plugin.getSettings().getSpicordSendChannelMap().get(event.getGuildChannel().getId()));
            if (serverChannelId.isEmpty()) {
                return;
            }
            new ChatMessage(serverChannelId.get(), new SpicordPlayer(this.plugin, event.getAuthor(), event.getMessage()), event.getMessage().getContentRaw(), this.plugin).dispatch();
        }

        public void onShutdown(@NotNull DiscordBot bot) {
            this.plugin.log(Level.INFO, "Shutting down HuskChat Spicord addon...", new Throwable[0]);
        }
    }

    public static class SpicordPlayer
    implements Player {
        private final HuskChat plugin;
        private final User discordUser;
        private final Message context;

        private SpicordPlayer(@NotNull HuskChat plugin, @NotNull User discordUser, @NotNull Message context) {
            this.plugin = plugin;
            this.discordUser = discordUser;
            this.context = context;
        }

        @Override
        @NotNull
        public String getName() {
            return this.plugin.getSettings().getDiscordUsernameFormat().replaceAll("%discord_handle%", this.getDiscriminatorString().map(discriminator -> String.format("%s%s", this.discordUser.getName(), discriminator)).orElse(this.discordUser.getName()));
        }

        private Optional<String> getDiscriminatorString() {
            try {
                return Optional.of(Integer.parseInt(this.discordUser.getDiscriminator())).flatMap(d -> d > 0 ? Optional.of(String.format("#%04d", d)) : Optional.empty());
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }

        @Override
        @NotNull
        public UUID getUuid() {
            return UUID.nameUUIDFromBytes(this.discordUser.getId().getBytes());
        }

        @Override
        public int getPing() {
            return 0;
        }

        @Override
        @NotNull
        public String getServerName() {
            return String.format("#%s", this.context.getChannel().getName());
        }

        @Override
        public int getPlayersOnServer() {
            return 0;
        }

        @Override
        public boolean hasPermission(@NotNull String node) {
            return true;
        }

        @Override
        public void sendMessage(@NotNull Component component) {
            try {
                this.context.reply((CharSequence)DiscordSerializer.INSTANCE.serialize(component)).queue();
            }
            catch (Throwable e) {
                this.plugin.log(Level.WARNING, "Unable to send contextual reply via Spicord to Discord user", e);
            }
        }

        @Override
        @NotNull
        public Audience getAudience() {
            throw new UnsupportedOperationException("Discord players cannot be used as an audience");
        }
    }
}

