/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.libraries.profanitycheckerapi;

import java.util.List;
import jep.Interpreter;
import jep.MainInterpreter;
import jep.SharedInterpreter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.libraries.profanitycheckerapi.Normalizer;
import net.william278.huskchat.libraries.profanitycheckerapi.ProfanityCheckerBuilder;

public class ProfanityChecker
implements AutoCloseable {
    private Interpreter interpreter;
    @Nullable
    private final String libraryPath;
    @NotNull
    private final List<Normalizer> normalizers;
    private final boolean useThreshold;
    private final double threshold;

    protected ProfanityChecker(@Nullable String libraryPath, @NotNull List<Normalizer> normalizers, boolean useThreshold, double threshold) {
        this.libraryPath = libraryPath;
        this.normalizers = normalizers;
        this.useThreshold = useThreshold;
        this.threshold = threshold;
        this.initialize();
    }

    @NotNull
    public static ProfanityCheckerBuilder builder() {
        return new ProfanityCheckerBuilder();
    }

    private void initialize() {
        if (this.libraryPath != null) {
            MainInterpreter.setJepLibraryPath(this.libraryPath);
        }
        this.interpreter = new SharedInterpreter();
        this.interpreter.exec("from profanity_check import predict_prob, predict");
    }

    public boolean isProfane(@NotNull String text) {
        String normalized = this.normalizeText(text);
        return this.useThreshold ? this.getProfanityProbability(text) >= this.threshold : this.containsProfanity(text);
    }

    protected boolean containsProfanity(@NotNull String text) {
        this.interpreter.set("text", text);
        return this.interpreter.getValue("predict([text])[0].item()", Integer.class) == 1;
    }

    protected double getProfanityProbability(@NotNull String text) {
        this.interpreter.set("text", text);
        return this.interpreter.getValue("predict_prob([text])[0].item()", Double.class);
    }

    @NotNull
    private String normalizeText(@NotNull String text) {
        String normalized = text;
        for (Normalizer normalizer : this.normalizers) {
            normalized = normalizer.normalize(normalized);
        }
        return normalized;
    }

    @Override
    public void close() {
        if (this.interpreter != null) {
            this.interpreter.close();
        }
    }
}

