/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.listener;

import java.util.Map;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.channel.Channel;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.Player;

public abstract class PlayerListener {
    protected final HuskChat plugin;

    public PlayerListener(@NotNull HuskChat plugin) {
        this.plugin = plugin;
    }

    public final void handlePlayerSwitchServer(@NotNull Player player, @NotNull String newServer) {
        Map<String, String> defaultChannels = this.plugin.getSettings().getServerDefaultChannels();
        if (defaultChannels.containsKey(newServer)) {
            this.plugin.getPlayerCache().switchPlayerChannel(player, defaultChannels.get(newServer));
        } else {
            block0: for (Channel channel : this.plugin.getSettings().getChannels().values()) {
                if (!channel.getId().equalsIgnoreCase(this.plugin.getPlayerCache().getPlayerChannel(player.getUuid()))) continue;
                for (String restrictedServer : channel.getRestrictedServers()) {
                    if (!restrictedServer.equalsIgnoreCase(newServer)) continue;
                    this.plugin.getPlayerCache().switchPlayerChannel(player, this.plugin.getSettings().getDefaultChannel());
                    break block0;
                }
            }
        }
    }

    public final void handlePlayerJoin(@NotNull Player player) {
        if (this.plugin.getSettings().getJoinQuitBroadcastScope() == Channel.BroadcastScope.PASSTHROUGH) {
            return;
        }
        if (this.plugin.getSettings().doJoinMessages()) {
            this.plugin.getLocales().sendJoinMessage(player);
        }
    }

    public final void handlePlayerQuit(@NotNull Player player) {
        if (this.plugin.getSettings().getJoinQuitBroadcastScope() == Channel.BroadcastScope.PASSTHROUGH) {
            return;
        }
        if (this.plugin.getSettings().doQuitMessages()) {
            this.plugin.getLocales().sendQuitMessage(player);
        }
    }
}

