/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.message;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.filter.ChatFilter;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.player.ConsolePlayer;
import net.william278.huskchat.player.Player;
import net.william278.huskchat.player.PlayerCache;
import net.william278.huskchat.replacer.ReplacerFilter;

public class PrivateMessage {
    private final HuskChat plugin;
    private final List<String> targetUsernames;
    private final String message;
    private Player sender;

    public PrivateMessage(@NotNull Player sender, @NotNull List<String> targetUsernames, @NotNull String message, @NotNull HuskChat plugin) {
        this.sender = sender;
        this.targetUsernames = targetUsernames;
        this.message = message;
        this.plugin = plugin;
    }

    public void dispatch() {
        for (String restrictedServer : this.plugin.getSettings().getMessageCommandRestrictedServers()) {
            if (!restrictedServer.equalsIgnoreCase(this.sender.getServerName())) continue;
            this.plugin.getLocales().sendMessage(this.sender, "error_message_restricted_server", new String[0]);
            return;
        }
        if (this.targetUsernames.size() > 1 && !this.plugin.getSettings().doGroupMessages()) {
            this.plugin.getLocales().sendMessage(this.sender, "error_group_messages_disabled", new String[0]);
            return;
        }
        ArrayList<Player> targetPlayers = new ArrayList<Player>();
        HashSet<UUID> targetUUIDs = new HashSet<UUID>();
        for (String targetUsername : this.targetUsernames) {
            Optional<Player> targetPlayer = ConsolePlayer.isConsolePlayer(targetUsername) ? Optional.of(ConsolePlayer.create(this.plugin)) : this.plugin.findPlayer(targetUsername);
            if (!targetPlayer.isPresent()) continue;
            if (targetPlayer.get().getUuid().equals(this.sender.getUuid())) {
                this.plugin.getLocales().sendMessage(this.sender, "error_cannot_message_self", new String[0]);
                return;
            }
            if (targetUUIDs.contains(targetPlayer.get().getUuid())) continue;
            targetPlayers.add(targetPlayer.get());
            targetUUIDs.add(targetPlayer.get().getUuid());
        }
        int maxGroupMembers = this.plugin.getSettings().getMaxGroupMessageSize();
        if (targetPlayers.size() > maxGroupMembers) {
            this.plugin.getLocales().sendMessage(this.sender, "error_group_messages_max", Integer.toString(maxGroupMembers));
            return;
        }
        if (targetPlayers.isEmpty()) {
            if (this.targetUsernames.size() > 1) {
                this.plugin.getLocales().sendMessage(this.sender, "error_players_not_found", new String[0]);
            } else {
                this.plugin.getLocales().sendMessage(this.sender, "error_player_not_found", new String[0]);
            }
            return;
        }
        AtomicReference<String> finalMessage = new AtomicReference<String>(this.message);
        if (!this.sender.hasPermission("huskchat.bypass_filters")) {
            for (ChatFilter filter : this.plugin.getSettings().getChatFilters().get("private_messages")) {
                if (this.sender.hasPermission(filter.getFilterIgnorePermission())) continue;
                if (this.plugin.getSettings().isCensorPrivateMessages() && !filter.isAllowed(this.sender, finalMessage.get())) {
                    this.plugin.getLocales().sendMessage(this.sender, filter.getFailureErrorMessageId(), new String[0]);
                    return;
                }
                ChatFilter chatFilter = filter;
                if (!(chatFilter instanceof ReplacerFilter)) continue;
                ReplacerFilter replacer = (ReplacerFilter)chatFilter;
                finalMessage.set(replacer.replace(finalMessage.get()));
            }
        }
        this.plugin.getEventDispatcher().dispatchPrivateMessageEvent(this.sender, targetPlayers, finalMessage.get()).thenAccept(event -> {
            if (event.isCancelled()) {
                return;
            }
            this.sender = event.getSender();
            List<Player> receivers = event.getRecipients();
            finalMessage.set(event.getMessage());
            PlayerCache.setLastMessenger(this.sender.getUuid(), receivers);
            this.plugin.getLocales().sendOutboundPrivateMessage(this.sender, receivers, (String)finalMessage.get());
            for (Player player2 : receivers) {
                ArrayList<Player> receivedMessageFrom = new ArrayList<Player>(receivers);
                receivedMessageFrom.removeIf(player -> player.getUuid().equals(player2.getUuid()));
                receivedMessageFrom.add(0, this.sender);
                PlayerCache.setLastMessenger(player2.getUuid(), receivedMessageFrom);
            }
            this.plugin.getLocales().sendInboundPrivateMessage(receivers, this.sender, (String)finalMessage.get());
            if (this.plugin.getSettings().doSocialSpyCommand() && !this.sender.hasPermission("huskchat.command.socialspy.bypass") && !((Player)receivers.stream().findFirst().orElseThrow(() -> new IllegalStateException("No receivers available for message"))).hasPermission("huskchat.command.socialspy.bypass")) {
                Map<Player, PlayerCache.SpyColor> spies = this.plugin.getPlayerCache().getSocialSpyMessageReceivers(receivers);
                for (Player spy : spies.keySet()) {
                    if (spy.getUuid().equals(this.sender.getUuid())) continue;
                    if (!spy.hasPermission("huskchat.command.socialspy")) {
                        try {
                            this.plugin.getPlayerCache().removeSocialSpy(spy);
                        }
                        catch (IOException e) {
                            this.plugin.log(Level.SEVERE, "Failed to remove social spy after failed permission check", e);
                        }
                        continue;
                    }
                    PlayerCache.SpyColor color = spies.get(spy);
                    this.plugin.getLocales().sendSocialSpy(spy, color, this.sender, receivers, (String)finalMessage.get());
                }
            }
            if (this.plugin.getSettings().doLogPrivateMessages()) {
                StringJoiner formattedPlayers = new StringJoiner(", ");
                for (Player player3 : receivers) {
                    formattedPlayers.add(player3.getName());
                }
                String string = this.plugin.getSettings().getMessageLogFormat().replaceAll("%sender%", this.sender.getName()).replaceAll("%receiver%", formattedPlayers.toString());
                this.plugin.log(Level.INFO, string + finalMessage, new Throwable[0]);
            }
        });
    }
}

