/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.bungeecord.listener;

import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.bungeecord.player.BungeePlayer;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.listener.PlayerListener;
import net.william278.huskchat.message.ChatMessage;

public class BungeeListener
extends PlayerListener
implements Listener {
    public BungeeListener(@NotNull HuskChat plugin) {
        super(plugin);
    }

    @EventHandler(priority=32)
    public void onPlayerChat(ChatEvent e) {
        if (e.isCommand() || e.isProxyCommand() || e.isCancelled()) {
            return;
        }
        ProxiedPlayer player = (ProxiedPlayer)e.getSender();
        boolean shouldCancel = new ChatMessage(this.plugin.getPlayerCache().getPlayerChannel(player.getUniqueId()), BungeePlayer.adapt(player), e.getMessage(), this.plugin).dispatch();
        if (shouldCancel) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=32)
    public void onPlayerChangeServer(ServerSwitchEvent e) {
        String server = e.getPlayer().getServer().getInfo().getName();
        BungeePlayer player = BungeePlayer.adapt(e.getPlayer());
        this.handlePlayerSwitchServer(player, server);
    }

    @EventHandler
    public void onPlayerJoinNetwork(PostLoginEvent e) {
        super.handlePlayerJoin(BungeePlayer.adapt(e.getPlayer()));
    }

    @EventHandler
    public void onPlayerQuitNetwork(PlayerDisconnectEvent e) {
        super.handlePlayerQuit(BungeePlayer.adapt(e.getPlayer()));
    }
}

