/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.velocity.listener;

import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.listener.PlayerListener;
import net.william278.huskchat.message.ChatMessage;
import net.william278.huskchat.velocity.player.VelocityPlayer;

public class VelocityListener
extends PlayerListener {
    public VelocityListener(@NotNull HuskChat plugin) {
        super(plugin);
    }

    @Subscribe(order=PostOrder.LAST)
    public void onPlayerChat(PlayerChatEvent e) {
        if (e.getMessage().startsWith("/") || !e.getResult().isAllowed()) {
            return;
        }
        VelocityPlayer player = VelocityPlayer.adapt(e.getPlayer());
        boolean shouldCancel = new ChatMessage(this.plugin.getPlayerCache().getPlayerChannel(player.getUuid()), player, e.getMessage(), this.plugin).dispatch();
        if (shouldCancel) {
            e.setResult(PlayerChatEvent.ChatResult.denied());
        }
    }

    @Subscribe
    public void onPlayerChangeServer(ServerConnectedEvent e) {
        String server = e.getServer().getServerInfo().getName();
        VelocityPlayer player = VelocityPlayer.adapt(e.getPlayer());
        this.handlePlayerSwitchServer(player, server);
    }

    @Subscribe
    public void onPlayerJoinNetwork(PostLoginEvent e) {
        this.handlePlayerJoin(VelocityPlayer.adapt(e.getPlayer()));
    }

    @Subscribe
    public void onPlayerQuitNetwork(DisconnectEvent e) {
        this.handlePlayerQuit(VelocityPlayer.adapt(e.getPlayer()));
    }
}

