/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.message.PrivateMessage;
import net.william278.huskchat.user.ConsoleUser;
import net.william278.huskchat.user.OnlineUser;

public class ReplyCommand
extends CommandBase {
    public ReplyCommand(@NotNull HuskChat plugin) {
        super(plugin.getSettings().getMessageCommand().getReplyAliases(), "<message>", plugin);
    }

    @Override
    public void onExecute(@NotNull OnlineUser player, @NotNull String[] args) {
        if (args.length >= 1) {
            Optional<Set<UUID>> lastMessengers = this.plugin.getUserCache().getLastMessengers(player.getUuid());
            if (lastMessengers.isEmpty()) {
                this.plugin.getLocales().sendMessage(player, "error_reply_no_messages", new String[0]);
                return;
            }
            ArrayList<String> lastPlayers = new ArrayList<String>();
            for (UUID uUID : lastMessengers.get()) {
                if (ConsoleUser.isConsolePlayer(uUID)) {
                    lastPlayers.add(ConsoleUser.wrap(this.plugin).getName());
                    continue;
                }
                this.plugin.getPlayer(uUID).ifPresent(online -> lastPlayers.add(online.getName()));
            }
            if (lastPlayers.isEmpty()) {
                if (lastMessengers.get().size() > 1) {
                    this.plugin.getLocales().sendMessage(player, "error_reply_none_online", new String[0]);
                } else {
                    this.plugin.getLocales().sendMessage(player, "error_reply_not_online", new String[0]);
                }
                return;
            }
            StringJoiner message = new StringJoiner(" ");
            for (String arg : args) {
                message.add(arg);
            }
            String string = message.toString();
            new PrivateMessage(player, lastPlayers, string, this.plugin).dispatch();
        } else {
            this.plugin.getLocales().sendMessage(player, "error_invalid_syntax", this.getUsage());
        }
    }

    @Override
    @Nullable
    public String getPermission(String ... args) {
        return String.join((CharSequence)".", "huskchat", "command", "msg", "reply", String.join((CharSequence)".", args));
    }
}

