/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.command;

import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.VelocityHuskChat;
import net.william278.huskchat.command.BroadcastCommand;
import net.william278.huskchat.command.ChannelCommand;
import net.william278.huskchat.command.CommandBase;
import net.william278.huskchat.command.HuskChatCommand;
import net.william278.huskchat.command.LocalSpyCommand;
import net.william278.huskchat.command.MessageCommand;
import net.william278.huskchat.command.OptOutMessageCommand;
import net.william278.huskchat.command.ReplyCommand;
import net.william278.huskchat.command.SocialSpyCommand;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.user.ConsoleUser;
import net.william278.huskchat.user.VelocityUser;

public class VelocityCommand
implements SimpleCommand {
    private final VelocityHuskChat plugin;
    private final CommandBase command;

    public VelocityCommand(@NotNull CommandBase command, @NotNull VelocityHuskChat plugin) {
        this.command = command;
        this.plugin = plugin;
        plugin.getProxyServer().getCommandManager().register(command.getName(), (Command)this, command.getAliases().toArray(new String[0]));
    }

    public void execute(@NotNull SimpleCommand.Invocation invocation) {
        CommandSource commandSource = invocation.source();
        if (commandSource instanceof Player) {
            Player player = (Player)commandSource;
            this.command.onExecute(VelocityUser.adapt(player, this.plugin), (String[])invocation.arguments());
        } else {
            this.command.onExecute(ConsoleUser.wrap(this.plugin), (String[])invocation.arguments());
        }
    }

    public List<String> suggest(@NotNull SimpleCommand.Invocation invocation) {
        CommandSource commandSource = invocation.source();
        if (!(commandSource instanceof Player)) {
            return this.command.onTabComplete(this.plugin.getConsoleUser(), (String[])invocation.arguments());
        }
        Player player = (Player)commandSource;
        VelocityUser user = VelocityUser.adapt(player, this.plugin);
        if (!user.hasPermission(this.command.getPermission(new String[0]), !this.command.isOperatorOnly())) {
            return List.of();
        }
        return this.command.onTabComplete(user, (String[])invocation.arguments());
    }

    public boolean hasPermission(@NotNull SimpleCommand.Invocation invocation) {
        CommandSource commandSource = invocation.source();
        if (commandSource instanceof Player) {
            Player player = (Player)commandSource;
            return VelocityUser.adapt(player, this.plugin).hasPermission(this.command.getPermission(new String[0]), !this.command.isOperatorOnly());
        }
        return true;
    }

    public static enum Type {
        HUSKCHAT(plugin -> Optional.of(new VelocityCommand(new HuskChatCommand((HuskChat)plugin), (VelocityHuskChat)plugin))),
        CHANNEL(plugin -> Optional.of(new VelocityCommand(new ChannelCommand((HuskChat)plugin), (VelocityHuskChat)plugin))),
        MESSAGE(plugin -> plugin.getSettings().getMessageCommand().isEnabled() ? Optional.of(new VelocityCommand(new MessageCommand((HuskChat)plugin), (VelocityHuskChat)plugin)) : Optional.empty()),
        REPLY(plugin -> plugin.getSettings().getMessageCommand().isEnabled() ? Optional.of(new VelocityCommand(new ReplyCommand((HuskChat)plugin), (VelocityHuskChat)plugin)) : Optional.empty()),
        OPT_OUT_MESSAGE(plugin -> plugin.getSettings().getMessageCommand().isEnabled() ? Optional.of(new VelocityCommand(new OptOutMessageCommand((HuskChat)plugin), (VelocityHuskChat)plugin)) : Optional.empty()),
        BROADCAST(plugin -> plugin.getSettings().getBroadcastCommand().isEnabled() ? Optional.of(new VelocityCommand(new BroadcastCommand((HuskChat)plugin), (VelocityHuskChat)plugin)) : Optional.empty()),
        SOCIAL_SPY(plugin -> plugin.getSettings().getSocialSpy().isEnabled() ? Optional.of(new VelocityCommand(new SocialSpyCommand((HuskChat)plugin), (VelocityHuskChat)plugin)) : Optional.empty()),
        LOCAL_SPY(plugin -> plugin.getSettings().getLocalSpy().isEnabled() ? Optional.of(new VelocityCommand(new LocalSpyCommand((HuskChat)plugin), (VelocityHuskChat)plugin)) : Optional.empty());

        private final Function<VelocityHuskChat, Optional<VelocityCommand>> commandSupplier;

        private Type(Function<VelocityHuskChat, Optional<VelocityCommand>> commandSupplier) {
            this.commandSupplier = commandSupplier;
        }

        private void register(@NotNull VelocityHuskChat plugin) {
            this.commandSupplier.apply(plugin);
        }

        public static void registerAll(@NotNull VelocityHuskChat plugin) {
            Arrays.stream(Type.values()).forEach(type -> type.register(plugin));
        }
    }
}

