/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskchat.user;

import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.william278.huskchat.HuskChat;
import net.william278.huskchat.libraries.annotations.NotNull;
import net.william278.huskchat.libraries.annotations.Nullable;
import net.william278.huskchat.user.OnlineUser;

public class ConsoleUser
extends OnlineUser {
    private static final UUID CONSOLE_UUID = new UUID(0L, 0L);
    private static final String CONSOLE_USERNAME = "[CONSOLE]";

    private ConsoleUser(@NotNull HuskChat plugin) {
        super(CONSOLE_USERNAME, CONSOLE_UUID, plugin);
    }

    @Override
    public int getPing() {
        return 0;
    }

    @Override
    @NotNull
    public String getServerName() {
        return this.plugin.getPlatform();
    }

    @Override
    public int getPlayersOnServer() {
        return this.plugin.getOnlinePlayers().size();
    }

    @Override
    public boolean hasPermission(@Nullable String node, boolean allowByDefault) {
        return true;
    }

    @Override
    @NotNull
    public Audience getAudience() {
        return this.plugin.getConsole();
    }

    @NotNull
    public static ConsoleUser wrap(@NotNull HuskChat plugin) {
        return new ConsoleUser(plugin);
    }

    public static boolean isConsolePlayer(@NotNull UUID uuid) {
        return uuid.equals(CONSOLE_UUID);
    }

    public static boolean isConsolePlayer(@NotNull String username) {
        return username.equalsIgnoreCase(CONSOLE_USERNAME);
    }
}

